/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appletviewer;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

import sun.applet.AppletAudioClip;

/**
 * Context for a single applet.
 */
public final class SimpleAppletContext implements AppletContext {

    /** Applet of this context. */
    private final Applet applet;

    /** Name of the applet used in this context. */
    private final String appletName;

    /** Map of input streams associated with this context. */
    private final Map<String, InputStream> streams = new HashMap<String, InputStream>();

    /**
     * Constructor with applet and it's name.
     * 
     * @param applet Applet.
     * @param appletName Name of the applet.
     */
    public SimpleAppletContext(final Applet applet, final String appletName) {
        super();
        this.applet = applet;
        this.appletName = appletName;
    }

    /**
     * {@inheritDoc}
     */
    public final Applet getApplet(final String name) {
        if (name == appletName) {
            return applet;
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    public final Enumeration<Applet> getApplets() {
        return new Enumeration<Applet>() {

            private final boolean first = true;

            public final boolean hasMoreElements() {
                return first;
            }

            public final Applet nextElement() {
                if (first) {
                    return applet;
                }
                throw new NoSuchElementException();
            }

        };
    }

    /**
     * {@inheritDoc}
     */
    public final AudioClip getAudioClip(final URL url) {
        try {
            return new AppletAudioClip(url);
        } catch (final RuntimeException e) {
            return new AudioClip() {
                public void loop() {
                    // Ignore
                }

                public void play() {
                    // Ignore
                }

                public void stop() {
                    // Ignore
                }
            };
        }
    }

    /**
     * {@inheritDoc}
     */
    public final Image getImage(final URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    /**
     * {@inheritDoc}
     */
    public final InputStream getStream(final String key) {
        return streams.get(key);
    }

    /**
     * {@inheritDoc}
     */
    public final Iterator<String> getStreamKeys() {
        return streams.keySet().iterator();
    }

    /**
     * {@inheritDoc}
     */
    public final void setStream(final String key, final InputStream stream)
            throws IOException {
        streams.put(key, stream);
    }

    /**
     * {@inheritDoc}
     */
    public final void showDocument(final URL url) {
        // Ignore
    }

    /**
     * {@inheritDoc}
     */
    public final void showDocument(final URL url, final String target) {
        // Ignore
    }

    /**
     * {@inheritDoc}
     */
    public final void showStatus(final String status) {
        // Ignore
    }

    /**
     * Returns the applet associated with this applet.
     * 
     * @return Applet.
     */
    public final Applet getApplet() {
        return applet;
    }

}
