/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.glazedlists;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.utils4swing.annotations.AnnotationUtils;
import org.fuin.utils4swing.annotations.Label;
import org.fuin.utils4swing.annotations.TableColumn;
import org.fuin.utils4swing.glazedlists.TableFormatExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableFormatCreator<E> {
    private final ByteCodeGenerator generator;
    private final SgClassPool pool;

    public TableFormatCreator() {
        this(null, null);
    }

    public TableFormatCreator(SgClassPool pool, ByteCodeGenerator generator) {
        this.pool = pool == null ? new SgClassPool() : pool;
        this.generator = generator == null ? new ByteCodeGenerator() : generator;
    }

    private static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    private List<Col> findColumns(Class<E> clasz, Locale locale) {
        ArrayList<Col> list = new ArrayList<Col>();
        Field[] fields = clasz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            TableColumn tableColumn = fields[i].getAnnotation(TableColumn.class);
            if (tableColumn != null) {
                String fieldName = fields[i].getName();
                Label label = fields[i].getAnnotation(Label.class);
                String text = label == null ? AnnotationUtils.getStandardText(clasz, fieldName, locale) : AnnotationUtils.getLabelText(clasz, fieldName, label, locale);
                int pos = tableColumn.pos();
                int width = tableColumn.width();
                String getter = TableFormatCreator.getGetter(tableColumn, fieldName);
                list.add(new Col(pos, width, getter, text));
            }
            ++i;
        }
        Collections.sort(list);
        return list;
    }

    private static String getGetter(TableColumn tableColumn, String fieldName) {
        String getter = tableColumn.getter().length() > 0 ? tableColumn.getter() : "get" + TableFormatCreator.firstCharUpper(fieldName);
        return getter;
    }

    public TableFormatExt<E> create(Class<E> clasz) {
        return this.create(clasz, Locale.getDefault());
    }

    public TableFormatExt<E> create(Class<E> clasz, Locale locale) {
        String implName;
        String pkg = String.valueOf(clasz.getSimpleName()) + "TableFormat_" + locale;
        Class tableFormatImpl = this.getClassSilent(pkg, implName = String.valueOf(clasz.getSimpleName()) + "TableFormat_" + locale);
        if (tableFormatImpl == null) {
            List<Col> columns = this.findColumns(clasz, locale);
            if (columns.size() == 0) {
                throw new IllegalArgumentException("No '@TableColumn' annotations found in class '" + clasz.getName() + "'!");
            }
            SgClass tableFormatImplClass = this.createTableFormatImplClass(pkg, implName);
            this.addGetColumnCountMethod(tableFormatImplClass, columns);
            this.addGetColumnNameMethod(tableFormatImplClass, columns, clasz);
            this.addGetColumnValueMethod(tableFormatImplClass, columns, clasz);
            this.addGetColumnWidthMethod(tableFormatImplClass, columns);
            tableFormatImpl = this.generator.createClass(tableFormatImplClass);
        }
        return (TableFormatExt)this.generator.createInstance(tableFormatImpl);
    }

    private Class<TableFormatExt<E>> getClassSilent(String pkg, String implName) {
        Class<?> tableFormatImpl;
        try {
            tableFormatImpl = Class.forName(String.valueOf(pkg) + "." + implName);
        }
        catch (ClassNotFoundException e) {
            tableFormatImpl = null;
        }
        return tableFormatImpl;
    }

    private SgClass createTableFormatImplClass(String packageName, String implName) {
        String tableFormatInterfaceName = TableFormatExt.class.getName();
        SgClass tableFormatImplClass = new SgClass(packageName, implName);
        SgClass tableFormatInterface = SgClass.create((SgClassPool)this.pool, (String)tableFormatInterfaceName);
        tableFormatImplClass.addInterface(tableFormatInterface);
        return tableFormatImplClass;
    }

    private void addGetColumnWidthMethod(SgClass tableFormatImplClass, List<Col> columns) {
        SgMethod getColumnWidthMethod = new SgMethod(tableFormatImplClass, "public", SgClass.INT, "getColumnWidth");
        getColumnWidthMethod.addArgument(new SgArgument(SgClass.INT, "column"));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return " + columns.get(i).getWidth() + ";");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnWidthMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnWidthMethod);
    }

    private void addGetColumnValueMethod(SgClass tableFormatImplClass, List<Col> columns, Class<E> clasz) {
        SgMethod getColumnValueMethod = new SgMethod(tableFormatImplClass, "public", SgClass.OBJECT, "getColumnValue");
        getColumnValueMethod.addArgument(new SgArgument(SgClass.OBJECT, "obj"));
        getColumnValueMethod.addArgument(new SgArgument(SgClass.INT, "column"));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return ((" + clasz.getName() + ")obj)." + columns.get(i).getGetter() + "();");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnValueMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnValueMethod);
    }

    private void addGetColumnNameMethod(SgClass tableFormatImplClass, List<Col> columns, Class<E> clasz) {
        SgMethod getColumnNameMethod = new SgMethod(tableFormatImplClass, "public", SgClass.create((SgClassPool)this.pool, (String)"java.lang.String"), "getColumnName");
        getColumnNameMethod.addArgument(new SgArgument(SgClass.INT, "column"));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return \"" + columns.get(i).getKey() + "\";");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnNameMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnNameMethod);
    }

    private void addGetColumnCountMethod(SgClass tableFormatImplClass, List<Col> columns) {
        SgMethod getColumnCountMethod = new SgMethod(tableFormatImplClass, "public", SgClass.INT, "getColumnCount");
        getColumnCountMethod.addBodyLine("return " + columns.size() + ";");
        tableFormatImplClass.addMethod(getColumnCountMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Col
    implements Comparable<Col> {
        private final int width;
        private final int pos;
        private final String getter;
        private final String text;

        public Col(int pos, int width, String getter, String text) {
            this.pos = pos;
            this.width = width;
            this.getter = getter;
            this.text = text;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getPos() {
            return this.pos;
        }

        public final String getGetter() {
            return this.getter;
        }

        public final String getKey() {
            return this.text;
        }

        @Override
        public final int compareTo(Col col) {
            if (this.pos > col.pos) {
                return 1;
            }
            if (this.pos < col.pos) {
                return -1;
            }
            return 0;
        }
    }
}

