/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import org.fuin.utils4swing.common.FramePositioner;

public final class Utils4Swing {
    private Utils4Swing() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static JFrame createShowAndPosition(String title, Container content, boolean exitOnClose, FramePositioner positioner) {
        return Utils4Swing.createShowAndPosition(title, content, exitOnClose, true, positioner);
    }

    public static JFrame createShowAndPosition(String title, Container content, boolean exitOnClose, boolean resizable, FramePositioner positioner) {
        JFrame frame = new JFrame(title);
        frame.setContentPane(content);
        if (exitOnClose) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(1);
        }
        frame.setSize(content.getPreferredSize());
        positioner.position(frame);
        Insets insets = frame.getInsets();
        frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
        frame.setVisible(true);
        frame.setResizable(resizable);
        return frame;
    }

    public static String getPackagePath(Class clasz) {
        return clasz.getPackage().getName().replace('.', '/');
    }

    public static URL getResource(Class clasz, String name) {
        String nameAndPath = String.valueOf(Utils4Swing.getPackagePath(clasz)) + "/" + name;
        return clasz.getResource(nameAndPath);
    }

    public static ImageIcon loadIcon(Class clasz, String name) {
        URL url = Utils4Swing.getResource(clasz, name);
        return new ImageIcon(url);
    }

    public static void initLookAndFeel(String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing the Look And Feel!", e);
        }
    }

    public static void initSystemLookAndFeel() {
        Utils4Swing.initLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static Object createInstance(String className) {
        try {
            Class<?> clasz = Class.forName(className);
            return clasz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class!", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instanciating class!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing class!", e);
        }
    }

    public static void addToClasspath(String url) {
        try {
            Utils4Swing.addToClasspath(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsURL(URL[] urls, URL url) {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL element = uRLArray[n2];
            if (element.equals(url)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addToClasspath(URL url) {
        ClassLoader classLoader = Utils4Swing.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Cannot add '" + url + "' to classloader because it's not an URL classloader");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        if (!Utils4Swing.containsURL(urlClassLoader.getURLs(), url)) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)urlClassLoader, url);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static RootPaneContainer findRootPaneContainer(Component source) {
        Component comp = source;
        while (comp != null && !(comp instanceof RootPaneContainer)) {
            comp = comp.getParent();
        }
        if (comp instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)comp);
        }
        return null;
    }

    public static GlassPaneState showGlassPane(Component source) {
        RootPaneContainer rootPaneContainer = Utils4Swing.findRootPaneContainer(source);
        Component glassPane = rootPaneContainer.getGlassPane();
        MouseAdapter mouseListener = new MouseAdapter(){};
        Cursor cursor = glassPane.getCursor();
        glassPane.addMouseListener(mouseListener);
        glassPane.setVisible(true);
        glassPane.requestFocus();
        glassPane.setCursor(new Cursor(3));
        return new GlassPaneState(glassPane, mouseListener, KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), cursor);
    }

    public static void hideGlassPane(GlassPaneState state) {
        Component glassPane = state.getGlassPane();
        glassPane.removeMouseListener(state.getMouseListener());
        glassPane.setCursor(state.getCursor());
        glassPane.setVisible(false);
        if (state.getFocusOwner() != null) {
            state.getFocusOwner().requestFocus();
        }
    }

    public static final class GlassPaneState {
        private final Component glassPane;
        private final MouseListener mouseListener;
        private final Component focusOwner;
        private final Cursor cursor;

        public GlassPaneState(Component glassPane, MouseListener mouseListener, Component focusOwner, Cursor cursor) {
            this.glassPane = glassPane;
            this.mouseListener = mouseListener;
            this.focusOwner = focusOwner;
            this.cursor = cursor;
        }

        public Component getGlassPane() {
            return this.glassPane;
        }

        public MouseListener getMouseListener() {
            return this.mouseListener;
        }

        public Component getFocusOwner() {
            return this.focusOwner;
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

