/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import java.io.File;
import org.fuin.utils4swing.appstarter.ClasspathEntry;
import org.fuin.utils4swing.common.Utils4Swing;

public final class ClasspathBinDirEntry
implements ClasspathEntry {
    public static final String TYPE = "CLASSES_DIR";
    private final File dir;

    public ClasspathBinDirEntry(String dir) {
        this(new File(dir));
    }

    public ClasspathBinDirEntry(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("The argument 'dir' cannot be null!");
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The argument '" + dir + "' is not a directory!");
        }
        this.dir = dir;
    }

    public final String getType() {
        return TYPE;
    }

    public final String getValue() {
        return this.dir.toString();
    }

    public final void addToClasspath() {
        Utils4Swing.addToClasspath(this.dir.toURI().toString());
    }
}

