/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appstarter;

/**
 * Types of applications that can be started. 
 */
public final class StartType {

    /** Application with "main" method. */
    public static final StartType APPLICATION = new StartType("Application");

    /** Applet. */
    public static final StartType APPLET = new StartType("Applet");

    /** Array of known types. */
    public static final StartType[] INSTANCES = new StartType[] { APPLICATION,
            APPLET };

    private final String name;
    
    private StartType(final String name) {
        super();
        if (name == null) {
            throw new IllegalArgumentException(
                    "The argument 'name' cannot be null!");
        }
        this.name = name;
    }

    /**
     * Returns the name of the type.
     * 
     * @return Name of the type to be used in the UI.
     */
    public final String getName() {
        return name;
    }

    /**
     * Checks if a given name is valid.
     * 
     * @param name Name to check.
     * 
     * @return If the name is known TRUE else FALSE.
     */
    public static boolean isValid(final String name) {
        for (final StartType element : INSTANCES) {
            if (element.getName().equals(name)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Returns an instance for the given name.
     * 
     * @param name Name to get an instance for.
     * 
     * @return Type.
     */
    public static StartType forName(final String name) {
        for (final StartType element : INSTANCES) {
            if (element.getName().equals(name)) {
                return element;
            }
        }
        throw new IllegalArgumentException("The name '" + name
                + "' is unknown!");
    }

}
