/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.glazedlists;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.fuin.utils4swing.annotations.AnnotationUtils;
import org.fuin.utils4swing.annotations.Label;
import org.fuin.utils4swing.annotations.TableColumn;
import org.fuin.utils4swing.glazedlists.TableFormatExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableFormatCreator {
    private TableFormatCreator() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    private static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    private static List<Col> findColumns(Class clasz, Locale locale) {
        ArrayList<Col> list = new ArrayList<Col>();
        Field[] fields = clasz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            TableColumn tableColumn = fields[i].getAnnotation(TableColumn.class);
            if (tableColumn != null) {
                String fieldName = fields[i].getName();
                Label label = fields[i].getAnnotation(Label.class);
                String text = label == null ? AnnotationUtils.getStandardText(clasz, fieldName, locale) : AnnotationUtils.getLabelText(clasz, fieldName, label, locale);
                int pos = tableColumn.pos();
                int width = tableColumn.width();
                String getter = TableFormatCreator.getGetter(tableColumn, fieldName);
                list.add(new Col(pos, width, getter, text));
            }
            ++i;
        }
        Collections.sort(list);
        return list;
    }

    private static String getGetter(TableColumn tableColumn, String fieldName) {
        String getter = tableColumn.getter().length() > 0 ? tableColumn.getter() : "get" + TableFormatCreator.firstCharUpper(fieldName);
        return getter;
    }

    private static String createGetColumnNameSource(Class clasz, List<Col> columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("public String getColumnName(int column) {");
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("    if (column == " + i + ") {");
            } else {
                sb.append("    } else if (column == " + i + ") {");
            }
            sb.append("        return \"" + columns.get(i).getKey() + "\";");
            ++i;
        }
        sb.append("    }");
        sb.append("    throw new IllegalStateException(\"Unknown colum # \" + column);");
        sb.append("}");
        return sb.toString();
    }

    private static String createGetColumnValueSource(Class clasz, List<Col> columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("public Object getColumnValue(Object obj, int column) {");
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("\t\tif (column == " + i + ") {");
            } else {
                sb.append("\t\t} else if (column == " + i + ") {");
            }
            sb.append("\t\t\treturn ((" + clasz.getName() + ")obj)." + columns.get(i).getGetter() + "();");
            ++i;
        }
        sb.append("\t\t}");
        sb.append("\t\tthrow new IllegalStateException(\"Unknown colum # \" + column);");
        sb.append("}");
        return sb.toString();
    }

    private static String createGetColumnWidthSource(Class clasz, List<Col> columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("public int getColumnWidth(int column) {");
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("    if (column == " + i + ") {");
            } else {
                sb.append("    } else if (column == " + i + ") {");
            }
            sb.append("        return " + columns.get(i).getWidth() + ";");
            ++i;
        }
        sb.append("    }");
        sb.append("    throw new IllegalStateException(\"Unknown colum # \" + column);");
        sb.append("}");
        return sb.toString();
    }

    public static TableFormatExt create(Class clasz) {
        return TableFormatCreator.create(clasz, Locale.getDefault());
    }

    public static TableFormatExt create(Class clasz, Locale locale) {
        try {
            Class tableFormatImpl;
            String tableFormatImplName = String.valueOf(clasz.getName()) + "TableFormat_" + locale;
            try {
                tableFormatImpl = Class.forName(tableFormatImplName);
            }
            catch (ClassNotFoundException e) {
                tableFormatImpl = null;
            }
            if (tableFormatImpl == null) {
                List<Col> columns = TableFormatCreator.findColumns(clasz, locale);
                if (columns.size() == 0) {
                    throw new IllegalArgumentException("No '@TableColumn' annotations found in class '" + clasz.getName() + "'!");
                }
                CtClass tableFormatImplClass = TableFormatCreator.createTableFormatImplClass(tableFormatImplName);
                TableFormatCreator.addGetColumnCountMethod(tableFormatImplClass, columns);
                TableFormatCreator.addGetColumnNameMethod(tableFormatImplClass, columns, clasz);
                TableFormatCreator.addGetColumnValueMethod(tableFormatImplClass, columns, clasz);
                TableFormatCreator.addGetColumnWidthMethod(tableFormatImplClass, columns, clasz);
                tableFormatImpl = tableFormatImplClass.toClass();
            }
            return (TableFormatExt)tableFormatImpl.newInstance();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static CtClass createTableFormatImplClass(String tableFormatImplName) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        String tableFormatInterfaceName = TableFormatExt.class.getName();
        CtClass tableFormatInterface = pool.get(tableFormatInterfaceName);
        CtClass tableFormatImplClass = pool.makeClass(tableFormatImplName);
        tableFormatImplClass.addInterface(tableFormatInterface);
        return tableFormatImplClass;
    }

    private static void addGetColumnWidthMethod(CtClass tableFormatImplClass, List<Col> columns, Class clasz) throws CannotCompileException {
        String getColumnWidthSrc = TableFormatCreator.createGetColumnWidthSource(clasz, columns);
        CtMethod getColumnWidthMethod = CtNewMethod.make((String)getColumnWidthSrc, (CtClass)tableFormatImplClass);
        tableFormatImplClass.addMethod(getColumnWidthMethod);
    }

    private static void addGetColumnValueMethod(CtClass tableFormatImplClass, List<Col> columns, Class clasz) throws CannotCompileException {
        String getColumnValueSrc = TableFormatCreator.createGetColumnValueSource(clasz, columns);
        CtMethod getColumnValueMethod = CtNewMethod.make((String)getColumnValueSrc, (CtClass)tableFormatImplClass);
        tableFormatImplClass.addMethod(getColumnValueMethod);
    }

    private static void addGetColumnNameMethod(CtClass tableFormatImplClass, List<Col> columns, Class clasz) throws CannotCompileException {
        String getColumnNameSrc = TableFormatCreator.createGetColumnNameSource(clasz, columns);
        CtMethod getColumnNameMethod = CtNewMethod.make((String)getColumnNameSrc, (CtClass)tableFormatImplClass);
        tableFormatImplClass.addMethod(getColumnNameMethod);
    }

    private static void addGetColumnCountMethod(CtClass tableFormatImplClass, List<Col> columns) throws CannotCompileException {
        String getColumnCountSrc = "public int getColumnCount() { return " + columns.size() + "; }";
        CtMethod getColumnCountMethod = CtNewMethod.make((String)getColumnCountSrc, (CtClass)tableFormatImplClass);
        tableFormatImplClass.addMethod(getColumnCountMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Col
    implements Comparable<Col> {
        private final int width;
        private final int pos;
        private final String getter;
        private final String text;

        public Col(int pos, int width, String getter, String text) {
            this.pos = pos;
            this.width = width;
            this.getter = getter;
            this.text = text;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getPos() {
            return this.pos;
        }

        public final String getGetter() {
            return this.getter;
        }

        public final String getKey() {
            return this.text;
        }

        @Override
        public final int compareTo(Col col) {
            if (this.pos > col.pos) {
                return 1;
            }
            if (this.pos < col.pos) {
                return -1;
            }
            return 0;
        }
    }
}

