/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import java.io.File;
import org.fuin.utils4swing.appstarter.ClasspathEntry;
import org.fuin.utils4swing.common.Utils4Swing;

public final class ClasspathJarFileEntry
implements ClasspathEntry {
    public static final String TYPE = "JAR_FILE";
    private final File file;

    public ClasspathJarFileEntry(String file) {
        this(new File(file));
    }

    public ClasspathJarFileEntry(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument 'file' cannot be null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The file '" + file + "' does not exist!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The argument '" + file + "' is not a file!");
        }
        this.file = file;
    }

    public final String getType() {
        return TYPE;
    }

    public final String getValue() {
        return this.file.toString();
    }

    public final void addToClasspath() {
        Utils4Swing.addToClasspath(this.file.toURI().toString());
    }
}

