/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import java.applet.Applet;
import java.awt.Container;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4swing.appletviewer.SimpleAppletViewer;
import org.fuin.utils4swing.appletviewer.SimpleAppletViewerConfig;
import org.fuin.utils4swing.appstarter.AppStarterConfig;
import org.fuin.utils4swing.appstarter.AppStarterConfigPanel;
import org.fuin.utils4swing.appstarter.AppStarterListener;
import org.fuin.utils4swing.appstarter.ClasspathEntry;
import org.fuin.utils4swing.appstarter.StartApplicationException;
import org.fuin.utils4swing.appstarter.StartType;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppStarter {
    private final AppStarterConfig config;
    private final AppStarterListener listener;
    private JFrame configFrame;

    public AppStarter(AppStarterConfig config) {
        this(config, null);
    }

    public AppStarter(AppStarterConfig config, AppStarterListener listener) {
        if (config == null) {
            throw new IllegalArgumentException("The argument 'config' cannot be null!");
        }
        this.config = config;
        this.listener = listener;
    }

    public final void start(StartType startType, List<ClasspathEntry> classpathEntries, String mainClass, List<String> arguments) throws StartApplicationException {
        AppStarter.start(startType, classpathEntries, mainClass, arguments, this.listener);
        this.configFrame.setVisible(false);
    }

    public static final void start(StartType startType, List<ClasspathEntry> classpathEntries, String mainClass, List<String> arguments, AppStarterListener listener) throws StartApplicationException {
        int i = 0;
        while (i < classpathEntries.size()) {
            classpathEntries.get(i).addToClasspath();
            ++i;
        }
        try {
            Class<?> clasz = Class.forName(mainClass);
            if (startType.equals(StartType.APPLET)) {
                AppStarter.startApplet(mainClass, arguments, clasz);
            } else {
                AppStarter.startApplication(mainClass, arguments, clasz);
            }
            if (listener != null) {
                listener.appStarted();
            }
        }
        catch (ClassNotFoundException e) {
            throw new StartApplicationException("Main class '" + mainClass + "' was not found in classpath!", e);
        }
    }

    private static void startApplet(String mainClass, List<String> arguments, Class clasz) throws StartApplicationException {
        if (!Applet.class.isAssignableFrom(clasz)) {
            throw new StartApplicationException("Main class '" + mainClass + "' is not an Applet!");
        }
        SimpleAppletViewerConfig appletViewerConfig = new SimpleAppletViewerConfig();
        appletViewerConfig.setApplet(mainClass);
        appletViewerConfig.setArguments(arguments);
        new SimpleAppletViewer(appletViewerConfig).execute();
    }

    private static void startApplication(String mainClass, List<String> arguments, Class clasz) throws StartApplicationException {
        try {
            Method method = clasz.getMethod("main", String[].class);
            String[] args = arguments.toArray(new String[arguments.size()]);
            method.invoke((Object)clasz, new Object[]{args});
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new StartApplicationException("SecurityException getting 'main(String[])' method!", e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new StartApplicationException("Main class '" + mainClass + "' has no 'main(String[])' method!", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new StartApplicationException("IllegalArgumentException calling 'main(String[])' method!", e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new StartApplicationException("IllegalAccessException calling 'main(String[])' method!", e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new StartApplicationException("InvocationTargetException calling 'main(String[])' method!", e);
        }
    }

    public final void execute() {
        this.configFrame = Utils4Swing.createShowAndPosition(this.config.getFrameTitle(), (Container)((Object)new AppStarterConfigPanel(this.config, this)), true, false, new ScreenCenterPositioner());
    }

    public static void main(String[] args) throws Exception {
        final AppStarterConfig config = new AppStarterConfig();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Utils4Swing.initSystemLookAndFeel();
                    new AppStarter(config).execute();
                }
            });
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java SwingRecorder [options...]");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
    }
}

