/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fuin.utils4j.Utils4J;

public class ChangeTrackingMap
implements Map {
    private final Map map;
    private final Map added;
    private final Map changed;
    private final Map removed;

    public ChangeTrackingMap(Map map) {
        Utils4J.checkNotNull("map", map);
        this.map = map;
        this.added = new HashMap();
        this.changed = new HashMap();
        this.removed = new HashMap();
    }

    public final boolean isChanged() {
        return this.added.size() > 0 || this.changed.size() > 0 || this.removed.size() > 0;
    }

    public final Map getRemoved() {
        return Collections.unmodifiableMap(this.removed);
    }

    public final Map getChanged() {
        return Collections.unmodifiableMap(this.changed);
    }

    public final void revert() {
        Iterator addedIt = this.added.keySet().iterator();
        while (addedIt.hasNext()) {
            Object key = addedIt.next();
            this.map.remove(key);
            addedIt.remove();
        }
        Iterator changedIt = this.changed.keySet().iterator();
        while (changedIt.hasNext()) {
            Object key = changedIt.next();
            Object value = this.changed.get(key);
            this.map.put(key, value);
            changedIt.remove();
        }
        Iterator removedIt = this.removed.keySet().iterator();
        while (removedIt.hasNext()) {
            Object key = removedIt.next();
            Object value = this.removed.get(key);
            this.map.put(key, value);
            removedIt.remove();
        }
    }

    public final Map getAdded() {
        return Collections.unmodifiableMap(this.added);
    }

    private void changeIntern(Object key, Object oldValue, Object newValue) {
        Object addedValue = this.added.get(key);
        if (addedValue == null) {
            Object changedValue = this.changed.get(key);
            if (changedValue == null) {
                Object removedValue = this.removed.get(key);
                if (removedValue == null) {
                    if (oldValue == null) {
                        this.added.put(key, newValue);
                    } else {
                        this.changed.put(key, oldValue);
                    }
                } else {
                    this.removed.remove(key);
                    if (!removedValue.equals(newValue)) {
                        this.changed.put(key, removedValue);
                    }
                }
            } else if (changedValue.equals(newValue)) {
                this.changed.remove(key);
            }
        } else if (!addedValue.equals(newValue) && newValue != null) {
            this.added.put(key, newValue);
        }
    }

    private void removeIntern(Object key, Object value) {
        if (this.added.get(key) == null) {
            Object changedValue = this.changed.get(key);
            if (changedValue == null) {
                if (this.removed.get(key) == null && value != null) {
                    this.removed.put(key, value);
                }
            } else {
                this.changed.remove(key);
                this.removed.put(key, changedValue);
            }
        } else {
            this.added.remove(key);
        }
    }

    public final void clear() {
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.map.get(key);
            this.removeIntern(key, value);
        }
        this.added.clear();
        this.map.clear();
    }

    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public final Set entrySet() {
        return this.map.entrySet();
    }

    public final Object get(Object key) {
        return this.map.get(key);
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Set keySet() {
        return this.map.keySet();
    }

    public final Object put(Object key, Object newValue) {
        Object oldValue = this.map.put(key, newValue);
        this.changeIntern(key, oldValue, newValue);
        return oldValue;
    }

    public final void putAll(Map newMap) {
        Iterator it = newMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object newValue = newMap.get(key);
            Object oldValue = this.map.put(key, newValue);
            this.changeIntern(key, oldValue, newValue);
        }
    }

    public final Object remove(Object key) {
        Object oldValue = this.map.remove(key);
        this.removeIntern(key, oldValue);
        return oldValue;
    }

    public final int size() {
        return this.map.size();
    }

    public final Collection values() {
        return this.map.values();
    }

    public final String toString() {
        return this.map.toString();
    }
}

