/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fuin.utils4j.filter.Filter;

public abstract class PropertyFilter
implements Filter {
    private final String propertyName;

    public PropertyFilter(String newPropertyName) {
        this.propertyName = newPropertyName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    protected abstract String[] createGetterNames(String var1);

    protected final Object getProperty(Object obj, String property) {
        if (obj == null || property == null || property.trim().length() == 0) {
            return null;
        }
        String[] getterNames = this.createGetterNames(property);
        int i = 0;
        while (i < getterNames.length) {
            String getter = getterNames[i];
            try {
                Class<?> cl = obj.getClass();
                Method m = cl.getMethod(getter, new Class[0]);
                return m.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Accessing " + getter + " method of property '" + property + "' failed (private? protected?)! [" + obj.getClass() + "]", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception within " + getter + " method of property '" + property + "'! [" + obj.getClass() + "]", e.getCause());
            }
            catch (NoSuchMethodException e) {
                if (i == getter.length() - 1) {
                    throw new RuntimeException("No " + getter + " method found for property! '" + property + "'! [" + obj.getClass() + "]", e);
                }
                ++i;
            }
        }
        throw new IllegalStateException("No getters defined in 'createGetterNames()'!");
    }
}

