/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.fuin.utils4j.Utils4J;

public class ChangeTrackingUniqueList
implements List {
    private final List list;
    private final List added;
    private final List deleted;

    public ChangeTrackingUniqueList(List list) {
        Utils4J.checkNotNull("list", list);
        this.list = list;
        this.added = new ArrayList();
        this.deleted = new ArrayList();
    }

    public final boolean isChanged() {
        return this.added.size() > 0 || this.deleted.size() > 0;
    }

    public final List getDeleted() {
        return Collections.unmodifiableList(this.deleted);
    }

    public final List getAdded() {
        return Collections.unmodifiableList(this.added);
    }

    private void addIntern(Object o) {
        int idx = this.deleted.indexOf(o);
        if (idx == -1) {
            this.added.add(o);
        } else {
            this.deleted.remove(idx);
        }
    }

    public final boolean add(Object o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        boolean b = this.list.add(o);
        if (b) {
            this.addIntern(o);
        }
        return b;
    }

    public final void add(int index, Object o) {
        if (this.list.contains(o)) {
            throw new IllegalArgumentException("The argument is already in the list: " + o);
        }
        this.list.add(index, o);
        this.addIntern(o);
    }

    private void checkDuplicates(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!this.list.contains(o)) continue;
            throw new IllegalArgumentException("At least one entry of the collection is already in the list: " + o);
        }
    }

    public final boolean addAll(Collection c) {
        this.checkDuplicates(c);
        boolean b = this.list.addAll(c);
        if (b) {
            this.added.addAll(c);
        }
        return b;
    }

    public final boolean addAll(int index, Collection c) {
        this.checkDuplicates(c);
        boolean b = this.list.addAll(index, c);
        if (b) {
            this.added.addAll(c);
        }
        return b;
    }

    public final void clear() {
        for (int i = 0; i < this.list.size(); ++i) {
            Object o = this.list.get(i);
            if (this.added.contains(o)) continue;
            this.deleted.add(o);
        }
        this.added.clear();
        this.list.clear();
    }

    public final boolean contains(Object o) {
        return this.list.contains(o);
    }

    public final boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public final Object get(int index) {
        return this.list.get(index);
    }

    public final int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final Iterator iterator() {
        return this.list.iterator();
    }

    public final int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public final ListIterator listIterator() {
        return this.list.listIterator();
    }

    public final ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    private void removeIntern(Object o) {
        int idx = this.added.indexOf(o);
        if (idx == -1) {
            this.deleted.add(o);
        } else {
            this.added.remove(idx);
        }
    }

    public final boolean remove(Object o) {
        boolean b = this.list.remove(o);
        if (b) {
            this.removeIntern(o);
        }
        return b;
    }

    public final Object remove(int index) {
        Object o = this.list.remove(index);
        if (o != null) {
            this.removeIntern(o);
        }
        return o;
    }

    public final boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    public final boolean retainAll(Collection c) {
        boolean changed = false;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object o = this.list.get(i);
            if (c.contains(o)) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    public final Object set(int index, Object o) {
        Object removed = this.list.set(index, o);
        this.addIntern(o);
        this.removeIntern(removed);
        return removed;
    }

    public final int size() {
        return this.list.size();
    }

    public final List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public final Object[] toArray() {
        return this.list.toArray();
    }

    public final Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }
}

