/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fuin.utils4j.filter.Filter;

public abstract class PropertyFilter
implements Filter {
    private final String propertyName;

    public PropertyFilter(String newPropertyName) {
        this.propertyName = newPropertyName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    private String createGetterName(String property) {
        return "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    protected final Object getProperty(Object obj, String property) {
        if (obj == null || property == null || property.trim().length() == 0) {
            return null;
        }
        try {
            Class<?> cl = obj.getClass();
            Method m = cl.getMethod(this.createGetterName(property), new Class[0]);
            return m.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Accessing getXXX method of property '" + property + "' failed (private? protected?)! [" + obj.getClass() + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception within getXXX method of property '" + property + "'! [" + obj.getClass() + "]", e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No getXXX method found for property! '" + property + "'! [" + obj.getClass() + "]", e);
        }
    }
}

