/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4j.IllegalNullArgumentException;
import org.fuin.utils4j.InvokeMethodFailedException;
import org.fuin.utils4j.LockingFailedException;

public final class Utils4J {
    private static final String USER_HOME_KEY = "user.home";
    private static final String TEMP_DIR_KEY = "java.io.tmpdir";
    private static final long EPOCH_DIFF = 11644473600000L;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private Utils4J() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static String getPackagePath(Class clasz) {
        return clasz.getPackage().getName().replace('.', '/');
    }

    public static URL getResource(Class clasz, String name) {
        String nameAndPath = "/" + Utils4J.getPackagePath(clasz) + "/" + name;
        return clasz.getResource(nameAndPath);
    }

    public static Properties loadProperties(Class clasz, String filename) {
        Utils4J.checkNotNull("clasz", clasz);
        Utils4J.checkNotNull("filename", filename);
        String path = Utils4J.getPackagePath(clasz);
        String resPath = "/" + path + "/" + filename;
        try {
            Properties props = new Properties();
            InputStream inStream = clasz.getResourceAsStream(resPath);
            if (inStream == null) {
                throw new IllegalArgumentException("Resource '" + resPath + "' was not found!");
            }
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(File file) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkValidFile(file);
        try {
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(file);
            try {
                props.load(inStream);
            }
            finally {
                ((InputStream)inStream).close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void checkValidFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file '" + file + "' does not exist!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The name '" + file + "' is not a file!");
        }
    }

    public static void checkValidDir(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The name '" + dir + "' is not a directory!");
        }
    }

    public static void saveProperties(File file, Properties props, String comment) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("props", props);
        if (!file.getParentFile().exists()) {
            throw new IllegalArgumentException("The parent directory '" + file.getParentFile() + "' does not exist [file='" + file + "']!");
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            try {
                props.store(outStream, comment);
            }
            finally {
                ((OutputStream)outStream).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object createInstance(String className) {
        try {
            Class<?> clasz = Class.forName(className);
            return clasz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class!", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instanciating class!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing class!", e);
        }
    }

    public static void addToClasspath(String url) {
        try {
            Utils4J.addToClasspath(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsURL(URL[] urls, URL url) {
        int i = 0;
        while (i < urls.length) {
            String urlStr;
            URL element = urls[i];
            String elementStr = element.toExternalForm();
            if (elementStr.equals(urlStr = url.toExternalForm())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String createHash(File file) {
        return Utils4J.createHashMD5(file);
    }

    public static String createHashMD5(File file) {
        return Utils4J.createHash(file, "MD5");
    }

    public static String createHash(File file, String algorithm) {
        String string;
        FileInputStream in = new FileInputStream(file);
        try {
            string = Utils4J.createHash(in, algorithm);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        in.close();
        return string;
    }

    public static String createHash(InputStream inputStream, String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            try {
                byte[] buf = new byte[1024];
                int count = 0;
                while ((count = in.read(buf)) > -1) {
                    messageDigest.update(buf, 0, count);
                }
            }
            finally {
                in.close();
            }
            return Utils4J.encodeHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL createUrl(URL baseUrl, String path, String filename) {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotNull("filename", filename);
        try {
            String baseUrlStr = baseUrl.toString();
            if (!baseUrlStr.endsWith("/")) {
                baseUrlStr = String.valueOf(baseUrlStr) + "/";
            }
            String pathStr = path == null || path.length() == 0 ? "" : (path.endsWith("/") ? path : String.valueOf(path) + "/");
            return new URL(String.valueOf(baseUrlStr) + pathStr + filename);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getRelativePath(File baseDir, File dir) {
        String path;
        String base;
        block4: {
            try {
                base = baseDir.getCanonicalPath();
                path = dir.getCanonicalPath();
                if (!path.startsWith(base)) {
                    throw new IllegalArgumentException("The path '" + path + "' is not inside the base directory '" + base + "'!");
                }
                if (!base.equals(path)) break block4;
                return "";
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return path.substring(base.length() + 1);
    }

    public static Properties loadProperties(URL baseUrl, String filename) {
        return Utils4J.loadProperties(Utils4J.createUrl(baseUrl, "", filename));
    }

    public static Properties loadProperties(URL fileURL) {
        try {
            Properties props = new Properties();
            InputStream inStream = fileURL.openStream();
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(String baseUrl, String filename) {
        try {
            URL url = new URL(baseUrl);
            return Utils4J.loadProperties(url, filename);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("The argument 'srcUrl' is not a valid URL [" + baseUrl + "]!", ex);
        }
    }

    public static void addToClasspath(URL url) {
        ClassLoader classLoader;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.fuin.utils4j.Utils4J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((classLoader = clazz.getClassLoader()) instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Cannot add '" + url + "' to classloader because it's not an URL classloader");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        if (!Utils4J.containsURL(urlClassLoader.getURLs(), url)) {
            try {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.net.URLClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class[] classArray = new Class[1];
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.net.URL");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz3;
                Method addURL = clazz2.getDeclaredMethod("addURL", classArray);
                addURL.setAccessible(true);
                addURL.invoke((Object)urlClassLoader, url);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalNullArgumentException(name);
        }
    }

    public static void checkNotEmpty(String name, String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be empty!!");
        }
    }

    private static String getMethodSignature(String returnType, String methodName, Class[] argTypes) {
        StringBuffer sb = new StringBuffer();
        if (returnType != null) {
            sb.append(returnType);
            sb.append(" ");
        }
        sb.append(methodName);
        sb.append("(");
        if (argTypes != null) {
            int i = 0;
            while (i < argTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getName());
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] args) throws InvokeMethodFailedException {
        String returnType = null;
        try {
            Method method = obj.getClass().getMethod(methodName, argTypes);
            returnType = method.getReturnType() == null ? "void" : method.getReturnType().getName();
            return method.invoke(obj, args);
        }
        catch (SecurityException ex) {
            throw new InvokeMethodFailedException("Security problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InvokeMethodFailedException("Method '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "' not found! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InvokeMethodFailedException("Argument problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvokeMethodFailedException("Access problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvokeMethodFailedException("Got an exception when calling '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
    }

    public static void unzip(File zipFile, File destDir) throws IOException {
        Utils4J.unzip(zipFile, destDir, null, null);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File zipFile, File destDir, UnzipInputStreamWrapper wrapper, Cancelable cancelable) throws IOException {
        Utils4J.checkNotNull("zipFile", zipFile);
        Utils4J.checkValidFile(zipFile);
        Utils4J.checkNotNull("destDir", destDir);
        Utils4J.checkValidDir(destDir);
        ZipFile zip = new ZipFile(zipFile);
        try {
            block18: {
                Enumeration<? extends ZipEntry> enu;
                block17: {
                    enu = zip.entries();
                    if (!true) break block17;
                    if (!enu.hasMoreElements()) return;
                    if (cancelable != null && cancelable.isCanceled()) break block18;
                }
                do {
                    ZipEntry entry;
                    File file;
                    if ((file = new File((entry = enu.nextElement()).getName())).isAbsolute()) {
                        throw new IllegalArgumentException("Only relative path entries are allowed! [" + entry.getName() + "]");
                    }
                    if (entry.isDirectory()) {
                        File dir = new File(destDir, entry.getName());
                        Utils4J.createIfNecessary(dir);
                    } else {
                        File outFile = new File(destDir, entry.getName());
                        Utils4J.createIfNecessary(outFile.getParentFile());
                        BufferedInputStream in = wrapper == null ? new BufferedInputStream(zip.getInputStream(entry)) : new BufferedInputStream(wrapper.wrapInputStream(zip.getInputStream(entry), entry, outFile));
                        try {
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                            try {
                                int len;
                                byte[] buf = new byte[4096];
                                while ((len = ((InputStream)in).read(buf)) > 0) {
                                    ((OutputStream)out).write(buf, 0, len);
                                }
                            }
                            finally {
                                ((OutputStream)out).close();
                            }
                        }
                        finally {
                            ((InputStream)in).close();
                        }
                    }
                    if (!enu.hasMoreElements()) return;
                } while (cancelable == null || !cancelable.isCanceled());
            }
            return;
        }
        finally {
            zip.close();
        }
    }

    private static void createIfNecessary(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir + "'!");
        }
    }

    public static File getUserHomeDir() {
        String str = System.getProperty(USER_HOME_KEY);
        if (str == null) {
            throw new IllegalStateException("System property 'user.home' not found!");
        }
        String userHome = str.trim();
        if (userHome.length() == 0) {
            throw new IllegalStateException("System property 'user.home' is empty!");
        }
        File dir = new File(userHome);
        try {
            Utils4J.checkValidDir(dir);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("System property 'user.home' is not valid! [" + ex.getMessage() + "]");
        }
        return dir;
    }

    public static File getTempDir() {
        String str = System.getProperty(TEMP_DIR_KEY);
        if (str == null) {
            throw new IllegalStateException("System property 'java.io.tmpdir' not found!");
        }
        String tempDirStr = str.trim();
        if (tempDirStr.length() == 0) {
            throw new IllegalStateException("System property 'java.io.tmpdir' is empty!");
        }
        File dir = new File(tempDirStr);
        try {
            Utils4J.checkValidDir(dir);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("System property 'java.io.tmpdir' is not valid! [" + ex.getMessage() + "]");
        }
        return dir;
    }

    public static String replaceVars(String str, Map vars) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        int end = -1;
        int from = 0;
        int start = -1;
        while ((start = str.indexOf("${", from)) > -1) {
            sb.append(str.substring(end + 1, start));
            end = str.indexOf(125, start + 1);
            if (end == -1) {
                sb.append(str.substring(start));
                from = str.length();
                continue;
            }
            String key = str.substring(start + 2, end);
            String value = (String)vars.get(key);
            if (value == null) {
                sb.append("${");
                sb.append(key);
                sb.append("}");
            } else {
                sb.append(value);
            }
            from = end + 1;
        }
        sb.append(str.substring(from));
        return sb.toString();
    }

    public static long dateToFileTime(Date date) {
        long msSince19700101 = date.getTime();
        long msSince16010101 = msSince19700101 + 11644473600000L;
        return msSince16010101 * 10000L;
    }

    public static void createWindowsDesktopUrlLink(String baseUrl, String url, File workingDir, Integer showCommand, Integer iconIndex, File iconFile, Integer hotKey, String linkFilenameWithoutExtension, boolean overwrite, Date modified) throws IOException {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotEmpty("baseUrl", baseUrl);
        Utils4J.checkNotNull("url", url);
        Utils4J.checkNotEmpty("url", url);
        Utils4J.checkNotNull("linkFilenameWithoutExtension", linkFilenameWithoutExtension);
        Utils4J.checkNotEmpty("linkFilenameWithoutExtension", linkFilenameWithoutExtension);
        File userHomeDir = new File(System.getProperty(USER_HOME_KEY));
        File desktopDir = new File(userHomeDir, "Desktop");
        File linkFile = new File(desktopDir, String.valueOf(linkFilenameWithoutExtension) + ".url");
        if (linkFile.exists() && !overwrite) {
            return;
        }
        String content = Utils4J.createWindowsDesktopUrlLinkContent(baseUrl, url, workingDir, showCommand, iconIndex, iconFile, hotKey, modified);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(linkFile), "Cp1252"));
        try {
            writer.write(content);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static String createWindowsDesktopUrlLinkContent(String baseUrl, String url, File workingDir, Integer showCommand, Integer iconIndex, File iconFile, Integer hotKey, Date modified) {
        StringBuffer sb = new StringBuffer();
        sb.append("[DEFAULT]\r\n");
        sb.append("BASEURL=" + baseUrl + "\r\n");
        sb.append("\r\n");
        sb.append("[InternetShortcut]\r\n");
        sb.append("URL=" + url + "\r\n");
        sb.append("WorkingDirectory=" + workingDir + "\r\n");
        if (showCommand != null) {
            sb.append("ShowCommand=" + showCommand);
        }
        if (iconFile != null && iconFile.exists()) {
            if (iconIndex == null) {
                sb.append("IconIndex=0\r\n");
            } else {
                sb.append("IconIndex=" + iconIndex);
            }
            sb.append("IconFile=" + iconFile + "\r\n");
        }
        sb.append("Modified=" + Utils4J.dateToFileTime(new Date()) + "\r\n");
        if (hotKey != null) {
            sb.append("HotKey=" + hotKey + "\r\n");
        }
        return sb.toString();
    }

    public static String concatPathAndFilename(String path, String filename, String separator) {
        Utils4J.checkNotNull("filename", filename);
        if (path == null) {
            return filename;
        }
        String trimmedPath = path.trim();
        if (trimmedPath.length() == 0) {
            return filename;
        }
        String trimmedFilename = filename.trim();
        if (trimmedPath.endsWith(separator)) {
            return String.valueOf(trimmedPath) + trimmedFilename;
        }
        return String.valueOf(trimmedPath) + separator + trimmedFilename;
    }

    public static String encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        int i = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return String.copyValueOf(out);
    }

    public static FileLock lockRandomAccessFile(RandomAccessFile file, int tryLockMax, long tryWaitMillis) throws LockingFailedException {
        FileChannel channel = file.getChannel();
        int tryCount = 0;
        while (tryCount < tryLockMax) {
            ++tryCount;
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
            }
            catch (IOException ex) {
                throw new LockingFailedException("Unexpected I/O-Exception!", ex);
            }
            catch (OverlappingFileLockException ex) {
                Utils4J.ignore();
            }
            try {
                Thread.sleep(tryWaitMillis);
            }
            catch (InterruptedException ex) {
                throw new LockingFailedException("Unexpected interrupt!", ex);
            }
        }
        throw new LockingFailedException("Number of max tries (" + tryLockMax + ") exceeded!");
    }

    private static void ignore() {
    }

    private static void zipFile(File srcFile, String destPath, ZipOutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
        try {
            int len;
            out.putNextEntry(new ZipEntry(Utils4J.concatPathAndFilename(destPath, srcFile.getName(), File.separator)));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static File[] listFiles(File srcDir, FileFilter filter) {
        File[] files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        return files;
    }

    private static void zipDir(File srcDir, FileFilter filter, String destPath, ZipOutputStream out) throws IOException {
        File[] files = Utils4J.listFiles(srcDir, filter);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Utils4J.zipDir(files[i], filter, Utils4J.concatPathAndFilename(destPath, files[i].getName(), File.separator), out);
            } else {
                Utils4J.zipFile(files[i], destPath, out);
            }
            ++i;
        }
    }

    public static void zipDir(File srcDir, FileFilter filter, String destPath, File destFile) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));
        try {
            Utils4J.zipDir(srcDir, filter, destPath, out);
        }
        finally {
            out.close();
        }
    }

    public static void zipDir(File srcDir, String destPath, File destFile) throws IOException {
        Utils4J.zipDir(srcDir, null, destPath, destFile);
    }

    public static interface UnzipInputStreamWrapper {
        public InputStream wrapInputStream(InputStream var1, ZipEntry var2, File var3);
    }
}

