/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import org.fuin.utils4j.Utils4J;

public class Property
implements Comparable {
    private final String key;
    private final String initialValue;
    private String value;

    public Property(String key, String initialValue, String value) {
        Utils4J.checkNotNull("key", key);
        this.key = key;
        this.initialValue = initialValue;
        this.value = value;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final String getInitialValue() {
        return this.initialValue;
    }

    public final String getKey() {
        return this.key;
    }

    public final boolean hasChanged() {
        if (this.initialValue == null) {
            return this.value != null;
        }
        return !this.initialValue.equals(this.value);
    }

    public final boolean isDeleted() {
        if (this.initialValue == null) {
            return false;
        }
        return this.value == null;
    }

    public final boolean isNew() {
        if (this.initialValue != null) {
            return false;
        }
        return this.value != null;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public final int compareTo(Object o) {
        Property other = (Property)o;
        return this.key.compareTo(other.key);
    }

    public final String toKeyValue() {
        return String.valueOf(this.key) + "=" + this.value;
    }

    public final String getStatus() {
        if (this.isNew()) {
            return "NEW";
        }
        if (this.isDeleted()) {
            return "DEL";
        }
        if (this.hasChanged()) {
            return "CHG";
        }
        return "---";
    }

    public final String toString() {
        return "[" + this.getStatus() + "] " + this.key + "=" + this.value;
    }
}

