/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.fuin.utils4j.PropertiesFilePreferences;

public final class PropertiesFilePreferencesFactory
implements PreferencesFactory {
    public static final String SYSTEM_PREF_DIR = "PropertiesFilePreferences.SystemDir";
    public static final String USER_PREF_FILE = "PropertiesFilePreferences.UserDir";
    private final String systemPrefDir;
    private final String userPrefDir;
    private PropertiesFilePreferences systemRoot = null;
    private PropertiesFilePreferences userRoot = null;

    public PropertiesFilePreferencesFactory() {
        this(System.getProperty(SYSTEM_PREF_DIR), System.getProperty(USER_PREF_FILE));
    }

    public PropertiesFilePreferencesFactory(String systemPrefDir, String userPrefDir) {
        this.systemPrefDir = systemPrefDir;
        this.userPrefDir = userPrefDir;
    }

    public final synchronized Preferences systemRoot() {
        if (this.systemRoot == null) {
            this.systemRoot = new PropertiesFilePreferences(new File(this.systemPrefDir));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        PropertiesFilePreferencesFactory.this.systemRoot.sync();
                    }
                    catch (BackingStoreException ex) {
                        System.err.println("Failed to save 'systemRoot' preferences!");
                        ex.printStackTrace(System.err);
                    }
                }
            });
        }
        return this.systemRoot;
    }

    public final synchronized Preferences userRoot() {
        if (this.userRoot == null) {
            this.userRoot = new PropertiesFilePreferences(new File(this.userPrefDir));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        PropertiesFilePreferencesFactory.this.userRoot.sync();
                    }
                    catch (BackingStoreException ex) {
                        System.err.println("Failed to save 'userRoot' preferences!");
                        ex.printStackTrace(System.err);
                    }
                }
            });
        }
        return this.userRoot;
    }
}

