/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.fuin.utils4j.IllegalNullArgumentException;
import org.fuin.utils4j.InvokeMethodFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils4J {
    private Utils4J() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static String getPackagePath(Class clasz) {
        return clasz.getPackage().getName().replace('.', '/');
    }

    public static URL getResource(Class clasz, String name) {
        String nameAndPath = Utils4J.getPackagePath(clasz) + "/" + name;
        return clasz.getResource(nameAndPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Class clasz, String filename) {
        Utils4J.checkNotNull("clasz", clasz);
        Utils4J.checkNotNull("filename", filename);
        String path = Utils4J.getPackagePath(clasz);
        String resPath = "/" + path + "/" + filename;
        try {
            Properties props = new Properties();
            InputStream inStream = clasz.getResourceAsStream(resPath);
            if (inStream == null) {
                throw new IllegalArgumentException("Resource '" + resPath + "' was not found!");
            }
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkValidFile(file);
        try {
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(file);
            try {
                props.load(inStream);
            }
            finally {
                ((InputStream)inStream).close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void checkValidFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file '" + file + "' does not exist!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The name '" + file + "' is not a file!");
        }
    }

    public static void checkValidDir(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The name '" + dir + "' is not a directory!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(File file, Properties props, String comment) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("props", props);
        if (!file.getParentFile().exists()) {
            throw new IllegalArgumentException("The parent directory '" + file.getParentFile() + "' does not exist [file='" + file + "']!");
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            try {
                props.store(outStream, comment);
            }
            finally {
                ((OutputStream)outStream).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object createInstance(String className) {
        try {
            Class<?> clasz = Class.forName(className);
            return clasz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown class!", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instanciating class!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing class!", e);
        }
    }

    public static void addToClasspath(String url) {
        try {
            Utils4J.addToClasspath(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsURL(URL[] urls, URL url) {
        for (URL element : urls) {
            if (!element.equals(url)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createHash(File file) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] buf = new byte[1024];
                BufferedInputStream in = new BufferedInputStream(fis);
                int count = 0;
                while ((count = in.read(buf)) > -1) {
                    messageDigest.update(buf, 0, count);
                }
            }
            finally {
                fis.close();
            }
            byte[] digest = messageDigest.digest();
            String digestStr = new BigInteger(1, digest).toString(16);
            if (digestStr.length() == 31) {
                return "0" + digestStr;
            }
            return digestStr;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL createUrl(URL baseUrl, String path, String filename) {
        try {
            String baseUrlStr = baseUrl.toString();
            if (!baseUrlStr.endsWith("/")) {
                baseUrlStr = baseUrlStr + "/";
            }
            String pathStr = path == null || path.length() == 0 ? "" : (path.endsWith("/") ? path : path + "/");
            return new URL(baseUrlStr + pathStr + filename);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getRelativePath(File baseDir, File dir) {
        try {
            String base = baseDir.getCanonicalPath();
            String path = dir.getCanonicalPath();
            if (!path.startsWith(base)) {
                throw new IllegalArgumentException("The path '" + path + "' is not inside the base directory '" + base + "'!");
            }
            if (base.equals(path)) {
                return "";
            }
            return path.substring(base.length() + 1);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(URL baseUrl, String filename) {
        try {
            Properties props = new Properties();
            InputStream inStream = Utils4J.createUrl(baseUrl, "", filename).openStream();
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void addToClasspath(URL url) {
        ClassLoader classLoader = Utils4J.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Cannot add '" + url + "' to classloader because it's not an URL classloader");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        if (!Utils4J.containsURL(urlClassLoader.getURLs(), url)) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)urlClassLoader, url);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalNullArgumentException(name);
        }
    }

    private static String getMethodSignature(Class<?> returnType, String methodName, Class<?> ... argTypes) {
        StringBuffer sb = new StringBuffer();
        if (returnType != null) {
            sb.append(returnType.getName());
            sb.append(" ");
        }
        sb.append(methodName);
        sb.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getName());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static Object invoke(Object obj, String methodName, Class<?>[] argTypes, Object[] args) throws InvokeMethodFailedException {
        Class<?> returnType = null;
        try {
            Method method = obj.getClass().getMethod(methodName, argTypes);
            returnType = method.getReturnType();
            return method.invoke(obj, args);
        }
        catch (SecurityException ex) {
            throw new InvokeMethodFailedException("Security problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InvokeMethodFailedException("Method '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "' not found! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InvokeMethodFailedException("Argument problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvokeMethodFailedException("Access problem with '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvokeMethodFailedException("Got an exception when calling '" + Utils4J.getMethodSignature(returnType, methodName, argTypes) + "'! [" + obj.getClass().getName() + "]", ex);
        }
    }
}

