/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.fuin.utils4j.Utils4J;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertCoverage {
    private AssertCoverage() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static final void assertEveryClassHasATest(Set<Class<?>> classes) {
        Utils4J.checkNotNull((String)"classes", classes);
        StringBuffer sb = new StringBuffer();
        for (Class<?> clasz : classes) {
            String testClassName = clasz.getName() + "Test";
            try {
                Class<?> testClass = Class.forName(testClassName);
                if (AssertCoverage.hasTestMethod(testClass)) continue;
                sb.append("\nThe test class '" + testClassName + "' contains no methods annotated with @Test");
            }
            catch (ClassNotFoundException ex) {
                sb.append("\nNo test class found for '" + clasz.getName() + "'");
            }
        }
        if (sb.length() > 0) {
            Assert.fail((String)sb.toString());
        }
    }

    public static final void assertEveryClassHasATest(File baseDir) {
        AssertCoverage.assertEveryClassHasATest(baseDir, new ClassFilter(){

            @Override
            public final boolean isIncludeClass(Class<?> clasz) {
                return true;
            }
        });
    }

    public static final void assertEveryClassHasATest(File baseDir, ClassFilter classFilter) {
        AssertCoverage.assertEveryClassHasATest(baseDir, true, classFilter);
    }

    public static final void assertEveryClassHasATest(File baseDir, boolean recursive) {
        AssertCoverage.assertEveryClassHasATest(baseDir, recursive, new ClassFilter(){

            @Override
            public final boolean isIncludeClass(Class<?> clasz) {
                return true;
            }
        });
    }

    public static final void assertEveryClassHasATest(File baseDir, boolean recursive, ClassFilter classFilter) {
        Utils4J.checkNotNull((String)"baseDir", (Object)baseDir);
        HashSet classes = new HashSet();
        AssertCoverage.analyzeDir(classes, baseDir, baseDir, recursive, classFilter);
        AssertCoverage.assertEveryClassHasATest(classes);
    }

    static void analyzeDir(Set<Class<?>> classes, File baseDir, File srcDir, boolean recursive, ClassFilter classFilter) {
        String packageName = Utils4J.getRelativePath((File)baseDir, (File)srcDir).replace(File.separatorChar, '.');
        File[] files = srcDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (!recursive) continue;
                    AssertCoverage.analyzeDir(classes, baseDir, files[i], recursive, classFilter);
                    continue;
                }
                if (!files[i].getName().endsWith(".java")) continue;
                String name = files[i].getName();
                String simpleName = name.substring(0, name.length() - 5);
                String className = packageName + "." + simpleName;
                try {
                    Class<?> clasz = Class.forName(className);
                    if (!AssertCoverage.isInclude(clasz, classFilter)) continue;
                    classes.add(clasz);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    static boolean isInclude(Class<?> clasz, ClassFilter classFilter) {
        int modifiers = clasz.getModifiers();
        return classFilter.isIncludeClass(clasz) && !clasz.isAnnotation() && !clasz.isEnum() && !clasz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    static boolean hasTestMethod(Class<?> testClass) {
        Method[] methods;
        boolean found = false;
        for (Method method : methods = testClass.getMethods()) {
            Test testAnnotation = method.getAnnotation(Test.class);
            if (testAnnotation == null) continue;
            found = true;
            break;
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassFilter {
        public boolean isIncludeClass(Class<?> var1);
    }
}

