/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyVisitor
implements AnnotationVisitor,
SignatureVisitor,
ClassVisitor,
FieldVisitor,
MethodVisitor {
    Set<String> packages = new HashSet<String>();
    Map<String, Map<String, Integer>> groups = new HashMap<String, Map<String, Integer>>();
    Map<String, Integer> current;
    String signatureClassName;

    public Map<String, Map<String, Integer>> getGlobals() {
        return this.groups;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String p = this.getGroupKey(name);
        this.current = this.groups.get(p);
        if (this.current == null) {
            this.current = new HashMap<String, Integer>();
            this.groups.put(p, this.current);
        }
        if (signature == null) {
            this.addInternalName(superName);
            this.addInternalNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this;
    }

    public void visitAttribute(Attribute attr) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addInternalNames(exceptions);
        return this;
    }

    public void visitSource(String source, String debug) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.addDesc(desc);
        return this;
    }

    public void visitTypeInsn(int opcode, String type) {
        this.addType(Type.getObjectType((String)type));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.addInternalName(owner);
        this.addDesc(desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.addInternalName(owner);
        this.addMethodDesc(desc);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.addType((Type)cst);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addDesc(desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.addTypeSignature(signature);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this;
    }

    public void visitCode() {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitInsn(int opcode) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitVarInsn(int opcode, int var) {
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitLabel(Label label) {
    }

    public void visitIincInsn(int var, int increment) {
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.addInternalName(type);
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            this.addType((Type)value);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.addDesc(desc);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.addDesc(desc);
        return this;
    }

    public AnnotationVisitor visitArray(String name) {
        return this;
    }

    public void visitFormalTypeParameter(String name) {
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public void visitBaseType(char descriptor) {
    }

    public void visitTypeVariable(String name) {
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    public void visitClassType(String name) {
        this.signatureClassName = name;
        this.addInternalName(name);
    }

    public void visitInnerClassType(String name) {
        this.signatureClassName = String.valueOf(this.signatureClassName) + "$" + name;
        this.addInternalName(this.signatureClassName);
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        return this;
    }

    public void visitEnd() {
    }

    private String getGroupKey(String name) {
        int n = name.lastIndexOf(47);
        if (n > -1) {
            name = name.substring(0, n);
        }
        this.packages.add(name);
        return name;
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        String p = this.getGroupKey(name);
        if (this.current.containsKey(p)) {
            this.current.put(p, this.current.get(p) + 1);
        } else {
            this.current.put(p, 1);
        }
    }

    private void addInternalName(String name) {
        if (name != null) {
            this.addType(Type.getObjectType((String)name));
        }
    }

    private void addInternalNames(String[] names) {
        int i = 0;
        while (names != null && i < names.length) {
            this.addInternalName(names[i]);
            ++i;
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        Type[] types = Type.getArgumentTypes((String)desc);
        int i = 0;
        while (i < types.length) {
            this.addType(types[i]);
            ++i;
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getInternalName());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this);
        }
    }
}

