/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dependencies {
    private final List<DependsOn> alwaysAllowed = new ArrayList<DependsOn>();
    private final List<NotDependsOn> alwaysForbidden = new ArrayList<NotDependsOn>();
    private final List<Package<DependsOn>> allowed = new ArrayList<Package<DependsOn>>();
    private final List<Package<NotDependsOn>> forbidden = new ArrayList<Package<NotDependsOn>>();

    public final List<DependsOn> getAlwaysAllowed() {
        if (this.alwaysAllowed == null) {
            return Collections.emptyList();
        }
        return this.alwaysAllowed;
    }

    public final List<NotDependsOn> getAlwaysForbidden() {
        if (this.alwaysForbidden == null) {
            return Collections.emptyList();
        }
        return this.alwaysForbidden;
    }

    public final boolean isAlwaysAllowed(String packageName) {
        if (packageName.equals("java.lang")) {
            return true;
        }
        return Utils.findByName(this.getAlwaysAllowed(), packageName) != null;
    }

    public final boolean isAlwaysForbidden(String packageName) {
        return Utils.findByName(this.getAlwaysForbidden(), packageName) != null;
    }

    public final List<Package<DependsOn>> getAllowed() {
        if (this.allowed == null) {
            return Collections.emptyList();
        }
        return this.allowed;
    }

    public final List<Package<NotDependsOn>> getForbidden() {
        if (this.forbidden == null) {
            return Collections.emptyList();
        }
        return this.forbidden;
    }

    public final void validate() throws InvalidDependenciesDefinitionException {
        int errorCount = 0;
        StringBuffer sb = new StringBuffer("Duplicate package entries in 'allowed' and 'forbidden': ");
        List<Package<NotDependsOn>> list = this.getForbidden();
        int i = 0;
        while (i < list.size()) {
            String name = list.get(i).getName();
            Package dep = new Package(name);
            if (this.getAllowed().indexOf(dep) > -1) {
                if (errorCount > 0) {
                    sb.append(", ");
                }
                sb.append(name);
                ++errorCount;
            }
            ++i;
        }
        if (errorCount > 0) {
            throw new InvalidDependenciesDefinitionException(this, sb.toString());
        }
    }

    public final Package<DependsOn> findAllowedByName(String packageName) {
        List<Package<DependsOn>> list = this.getAllowed();
        for (Package<DependsOn> pkg : list) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public final Package<NotDependsOn> findForbiddenByName(String packageName) {
        List<Package<NotDependsOn>> list = this.getForbidden();
        for (Package<NotDependsOn> pkg : list) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }
}

