/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.fuin.utils4j.Utils4J;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertCoverage {
    private AssertCoverage() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static final void assertEveryClassHasATest(Set<Class<?>> classes) {
        Utils4J.checkNotNull((String)"classes", classes);
        StringBuffer sb = new StringBuffer();
        for (Class<?> clasz : classes) {
            String testClassName = String.valueOf(clasz.getName()) + "Test";
            try {
                Class<?> testClass = Class.forName(testClassName);
                if (AssertCoverage.hasTestMethod(testClass)) continue;
                sb.append("\nThe test class '" + testClassName + "' contains no methods annotated with @Test");
            }
            catch (ClassNotFoundException ex) {
                sb.append("\nNo test class found for '" + clasz.getName() + "'");
            }
        }
        if (sb.length() > 0) {
            Assert.fail((String)sb.toString());
        }
    }

    public static final void assertEveryClassHasATest(File baseDir) {
        AssertCoverage.assertEveryClassHasATest(baseDir, true);
    }

    public static final void assertEveryClassHasATest(File baseDir, boolean recursive) {
        Utils4J.checkNotNull((String)"baseDir", (Object)baseDir);
        HashSet classes = new HashSet();
        AssertCoverage.analyzeDir(classes, baseDir, baseDir, recursive);
        AssertCoverage.assertEveryClassHasATest(classes);
    }

    private static boolean hasTestMethod(Class<?> testClass) {
        Method[] methods;
        boolean found = false;
        Method[] methodArray = methods = testClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Test testAnnotation = method.getAnnotation(Test.class);
            if (testAnnotation != null) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }

    static void analyzeDir(Set<Class<?>> classes, File baseDir, File srcDir, boolean recursive) {
        String packageName = Utils4J.getRelativePath((File)baseDir, (File)srcDir).replace(File.separatorChar, '.');
        File[] files = srcDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                if (recursive) {
                    AssertCoverage.analyzeDir(classes, baseDir, files[i], recursive);
                }
            } else if (files[i].getName().endsWith(".java")) {
                String name = files[i].getName();
                String simpleName = name.substring(0, name.length() - 5);
                String className = String.valueOf(packageName) + "." + simpleName;
                try {
                    Class<?> clasz = Class.forName(className);
                    int modifiers = clasz.getModifiers();
                    if (!(clasz.isAnnotation() || clasz.isInterface() || Modifier.isAbstract(modifiers))) {
                        classes.add(clasz);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ++i;
        }
    }
}

