/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.Dependency;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.utils4j.Utils4J;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static XStream createXStream() {
        XStream xstream = new XStream();
        xstream.alias("dependencies", Dependencies.class);
        xstream.alias("package", Package.class);
        xstream.alias("dependsOn", DependsOn.class);
        xstream.alias("notDependsOn", NotDependsOn.class);
        xstream.aliasField("package", Dependency.class, "packageName");
        xstream.useAttributeFor(Package.class, "name");
        xstream.useAttributeFor(Package.class, "comment");
        xstream.useAttributeFor(Dependency.class, "packageName");
        xstream.useAttributeFor(Dependency.class, "includeSubPackages");
        xstream.useAttributeFor(NotDependsOn.class, "comment");
        xstream.addImplicitCollection(Package.class, "dependencies");
        return xstream;
    }

    public static Dependencies load(File file) {
        Dependencies dependencies;
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkValidFile((File)file);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            dependencies = Utils.load(inputStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ((InputStream)inputStream).close();
        return dependencies;
    }

    public static Dependencies load(InputStream inputStream) {
        Utils4J.checkNotNull((String)"inputStream", (Object)inputStream);
        XStream xstream = Utils.createXStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        return (Dependencies)xstream.fromXML((Reader)reader);
    }

    public static Dependencies load(Class<?> clasz, String resourcePathAndName) {
        Dependencies dependencies;
        Utils4J.checkNotNull((String)"clasz", clasz);
        Utils4J.checkNotNull((String)"resourcePathAndName", (Object)resourcePathAndName);
        URL url = clasz.getResource(resourcePathAndName);
        if (url == null) {
            throw new RuntimeException("Resource '" + resourcePathAndName + "' not found!");
        }
        InputStream in = url.openStream();
        try {
            dependencies = Utils.load(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        in.close();
        return dependencies;
    }

    public static void save(File file, Dependencies dependencies) {
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkValidFile((File)file);
        XStream xstream = Utils.createXStream();
        try {
            FileWriter writer = new FileWriter(file);
            try {
                xstream.toXML((Object)dependencies, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DependsOn findByName(List<DependsOn> allowed, String pkgName) {
        Utils4J.checkNotNull((String)"allowed", allowed);
        Utils4J.checkNotNull((String)"pkgName", (Object)pkgName);
        int i = 0;
        while (i < allowed.size()) {
            DependsOn dep = allowed.get(i);
            if (pkgName.startsWith(dep.getPackageName())) {
                if (dep.isIncludeSubPackages()) {
                    return dep;
                }
                if (pkgName.equals(dep.getPackageName())) {
                    return dep;
                }
            }
            ++i;
        }
        return null;
    }

    public static NotDependsOn findByName(List<NotDependsOn> forbidden, String pkgName) {
        Utils4J.checkNotNull((String)"forbidden", forbidden);
        Utils4J.checkNotNull((String)"pkgName", (Object)pkgName);
        int i = 0;
        while (i < forbidden.size()) {
            NotDependsOn dep = forbidden.get(i);
            if (pkgName.startsWith(dep.getPackageName())) {
                if (dep.isIncludeSubPackages()) {
                    return dep;
                }
                if (pkgName.equals(dep.getPackageName())) {
                    return dep;
                }
            }
            ++i;
        }
        return null;
    }
}

