/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.DependencyError;
import org.fuin.units4j.dependency.DependencyVisitor;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;
import org.fuin.utils4j.Utils4J;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyAnalyzer {
    private final List<DependencyError> dependencyErrors;
    private final Dependencies dependencies;

    public DependencyAnalyzer(File dependenciesFile) throws InvalidDependenciesDefinitionException {
        this(Utils.load(dependenciesFile));
    }

    public DependencyAnalyzer(Class<?> clasz, String dependenciesFilePathAndName) throws InvalidDependenciesDefinitionException {
        this(Utils.load(clasz, dependenciesFilePathAndName));
    }

    public DependencyAnalyzer(Dependencies dependencies) throws InvalidDependenciesDefinitionException {
        Utils4J.checkNotNull((String)"dependencies", (Object)dependencies);
        this.dependencies = dependencies;
        this.dependencies.validate();
        this.dependencyErrors = new ArrayList<DependencyError>();
    }

    private void analyzeDir(File classesDir) throws IOException {
        File[] files = classesDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.analyzeDir(files[i]);
            } else if (files[i].getName().endsWith(".class")) {
                this.analyzeClass(files[i]);
            }
            ++i;
        }
    }

    private List<DependencyError> checkAllowedSection(Dependencies dependencies, Package<DependsOn> allowedPkg, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPkg : classInfo.getImports()) {
            DependsOn dep;
            if (importedPkg.equals(allowedPkg.getName()) || dependencies.isAlwaysAllowed(importedPkg) || (dep = Utils.findByName(allowedPkg.getDependencies(), importedPkg)) != null) continue;
            errors.add(new DependencyError(classInfo.getName(), importedPkg, allowedPkg.getComment()));
        }
        return errors;
    }

    private static List<DependencyError> checkForbiddenSection(Dependencies dependencies, Package<NotDependsOn> forbiddenPkg, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPkg : classInfo.getImports()) {
            if (importedPkg.equals(classInfo.getPackageName())) continue;
            NotDependsOn ndo = Utils.findByName(dependencies.getAlwaysForbidden(), importedPkg);
            if (ndo != null) {
                errors.add(new DependencyError(classInfo.getName(), importedPkg, ndo.getComment()));
                continue;
            }
            NotDependsOn dep = Utils.findByName(forbiddenPkg.getDependencies(), importedPkg);
            if (dep == null) continue;
            String comment = dep.getComment() == null ? forbiddenPkg.getComment() : dep.getComment();
            errors.add(new DependencyError(classInfo.getName(), importedPkg, comment));
        }
        return errors;
    }

    private static String nameOnly(String filename) {
        int p = filename.lastIndexOf(46);
        if (p == -1) {
            return filename;
        }
        return filename.substring(0, p);
    }

    private void analyzeClass(File classFile) throws IOException {
        ClassInfo classInfo = new ClassInfo(classFile);
        Package<DependsOn> allowedPkg = this.dependencies.findAllowedByName(classInfo.getPackageName());
        if (allowedPkg == null) {
            Package<NotDependsOn> forbiddenPkg = this.dependencies.findForbiddenByName(classInfo.getPackageName());
            if (forbiddenPkg == null) {
                this.dependencyErrors.addAll(DependencyAnalyzer.checkAlwaysForbiddenSection(this.dependencies, classInfo));
            } else {
                this.dependencyErrors.addAll(DependencyAnalyzer.checkForbiddenSection(this.dependencies, forbiddenPkg, classInfo));
            }
        } else {
            this.dependencyErrors.addAll(this.checkAllowedSection(this.dependencies, allowedPkg, classInfo));
        }
    }

    private static List<DependencyError> checkAlwaysForbiddenSection(Dependencies dependencies, ClassInfo classInfo) {
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        for (String importedPackage : classInfo.getImports()) {
            NotDependsOn ndo = Utils.findByName(dependencies.getAlwaysForbidden(), importedPackage);
            if (ndo == null) continue;
            errors.add(new DependencyError(classInfo.getName(), importedPackage, ndo.getComment()));
        }
        return errors;
    }

    public final void analyze(File classesDir) throws IOException {
        this.dependencyErrors.clear();
        this.analyzeDir(classesDir);
    }

    public final List<DependencyError> getDependencyErrors() {
        return this.dependencyErrors;
    }

    public final Dependencies getDependencies() {
        return this.dependencies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassInfo {
        private final String packageName;
        private final String simpleName;
        private final Set<String> imports;

        public ClassInfo(File classFile) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(classFile));
            try {
                DependencyVisitor visitor = new DependencyVisitor();
                new ClassReader((InputStream)in).accept((ClassVisitor)visitor, 0);
                Map<String, Map<String, Integer>> globals = visitor.getGlobals();
                Set<String> jarPackages = globals.keySet();
                this.packageName = jarPackages.iterator().next().replace('/', '.');
                this.simpleName = DependencyAnalyzer.nameOnly(classFile.getName());
                this.imports = new HashSet<String>();
                Iterator<String> it = visitor.getPackages().iterator();
                while (it.hasNext()) {
                    this.imports.add(it.next().replace('/', '.'));
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final Set<String> getImports() {
            return this.imports;
        }

        public final String getName() {
            return String.valueOf(this.packageName) + "." + this.simpleName;
        }
    }
}

