/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.DependencyAnalyzer;
import org.fuin.units4j.dependency.DependencyError;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.utils4j.Utils4J;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertDependencies {
    private AssertDependencies() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    private static void assertIntern(File classesDir, DependencyAnalyzer analyzer) {
        try {
            analyzer.analyze(classesDir);
            List<DependencyError> dependencyErrors = analyzer.getDependencyErrors();
            if (dependencyErrors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < dependencyErrors.size()) {
                    sb.append("\n");
                    sb.append(dependencyErrors.get(i));
                    ++i;
                }
                Assert.fail((String)sb.toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void assertRules(Dependencies dependencies, File classesDir) {
        Utils4J.checkNotNull((String)"dependencies", (Object)dependencies);
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        Utils4J.checkValidDir((File)classesDir);
        try {
            DependencyAnalyzer analyzer = new DependencyAnalyzer(dependencies);
            AssertDependencies.assertIntern(classesDir, analyzer);
        }
        catch (InvalidDependenciesDefinitionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void assertRules(File file, File classesDir) {
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        Utils4J.checkValidFile((File)file);
        Utils4J.checkValidDir((File)classesDir);
        try {
            DependencyAnalyzer analyzer = new DependencyAnalyzer(file);
            AssertDependencies.assertIntern(classesDir, analyzer);
        }
        catch (InvalidDependenciesDefinitionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void assertRules(Class<?> clasz, String dependenciesFilePathAndName, File classesDir) {
        Utils4J.checkNotNull((String)"clasz", clasz);
        Utils4J.checkNotNull((String)"dependenciesFilePathAndName", (Object)dependenciesFilePathAndName);
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        try {
            DependencyAnalyzer analyzer = new DependencyAnalyzer(clasz, dependenciesFilePathAndName);
            AssertDependencies.assertIntern(classesDir, analyzer);
        }
        catch (InvalidDependenciesDefinitionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

