/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.Dependency;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static XStream createXStream() {
        XStream xstream = new XStream();
        xstream.alias("dependencies", Dependencies.class);
        xstream.alias("package", Package.class);
        xstream.alias("dependsOn", DependsOn.class);
        xstream.alias("notDependsOn", NotDependsOn.class);
        xstream.aliasField("package", Dependency.class, "packageName");
        xstream.useAttributeFor(Package.class, "name");
        xstream.useAttributeFor(Package.class, "comment");
        xstream.useAttributeFor(Dependency.class, "packageName");
        xstream.useAttributeFor(Dependency.class, "includeSubPackages");
        xstream.useAttributeFor(NotDependsOn.class, "comment");
        xstream.addImplicitCollection(Package.class, "dependencies");
        return xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dependencies load(File file) {
        Dependencies dependencies;
        XStream xstream = Utils.createXStream();
        FileReader reader = new FileReader(file);
        try {
            dependencies = (Dependencies)xstream.fromXML((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ((Reader)reader).close();
        return dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, Dependencies dependencies) {
        XStream xstream = Utils.createXStream();
        try {
            FileWriter writer = new FileWriter(file);
            try {
                xstream.toXML((Object)dependencies, (Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DependsOn findByName(List<DependsOn> allowed, String pkgName) {
        for (int i = 0; i < allowed.size(); ++i) {
            DependsOn dep = allowed.get(i);
            if (!pkgName.startsWith(dep.getPackageName())) continue;
            if (dep.isIncludeSubPackages()) {
                return dep;
            }
            if (!pkgName.equals(dep.getPackageName())) continue;
            return dep;
        }
        return null;
    }

    public static NotDependsOn findByName(List<NotDependsOn> forbidden, String pkgName) {
        for (int i = 0; i < forbidden.size(); ++i) {
            NotDependsOn dep = forbidden.get(i);
            if (!pkgName.startsWith(dep.getPackageName())) continue;
            if (dep.isIncludeSubPackages()) {
                return dep;
            }
            if (!pkgName.equals(dep.getPackageName())) continue;
            return dep;
        }
        return null;
    }
}

