/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.util.ArrayList;
import java.util.List;
import org.fuin.units4j.dependency.Dependency;
import org.fuin.utils4j.ToDebugStringCapable;
import org.fuin.utils4j.Utils4J;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Package<DEP_TYPE extends Dependency>
implements ToDebugStringCapable {
    private final String name;
    private final String comment;
    private final List<DEP_TYPE> dependencies;

    public Package(String name) {
        this(name, null);
    }

    public Package(String name, String comment) {
        Utils4J.checkNotNull((String)"name", (Object)name);
        this.name = name;
        this.comment = comment;
        this.dependencies = new ArrayList<DEP_TYPE>();
    }

    public final String getName() {
        return this.name;
    }

    public final List<DEP_TYPE> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Package other = (Package)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final String getComment() {
        return this.comment;
    }

    public final String toString() {
        return this.name;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name=" + this.name + ", ");
        sb.append("comment=" + this.comment + ", ");
        sb.append("dependencies={");
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.dependencies.get(i));
        }
        sb.append("}");
        return sb.toString();
    }
}

