/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.util.ArrayList;
import java.util.List;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dependencies {
    private final List<DependsOn> alwaysAllowed = new ArrayList<DependsOn>();
    private final List<NotDependsOn> alwaysForbidden = new ArrayList<NotDependsOn>();
    private final List<Package<DependsOn>> allowed = new ArrayList<Package<DependsOn>>();
    private final List<Package<NotDependsOn>> forbidden = new ArrayList<Package<NotDependsOn>>();

    public final List<DependsOn> getAlwaysAllowed() {
        return this.alwaysAllowed;
    }

    public final List<NotDependsOn> getAlwaysForbidden() {
        return this.alwaysForbidden;
    }

    public final boolean isAlwaysAllowed(String packageName) {
        return Utils.findByName(this.alwaysAllowed, packageName) != null;
    }

    public final boolean isAlwaysForbidden(String packageName) {
        return Utils.findByName(this.alwaysForbidden, packageName) != null;
    }

    public final List<Package<DependsOn>> getAllowed() {
        return this.allowed;
    }

    public final List<Package<NotDependsOn>> getForbidden() {
        return this.forbidden;
    }

    public final void validate() throws InvalidDependenciesDefinitionException {
        int errorCount = 0;
        StringBuffer sb = new StringBuffer("Duplicate package entries in 'allowed' and 'forbidden': ");
        for (int i = 0; i < this.forbidden.size(); ++i) {
            String name = this.forbidden.get(i).getName();
            Package dep = new Package(name);
            if (this.allowed.indexOf(dep) <= -1) continue;
            if (errorCount > 0) {
                sb.append(", ");
            }
            sb.append(name);
            ++errorCount;
        }
        if (errorCount > 0) {
            throw new InvalidDependenciesDefinitionException(this, sb.toString());
        }
    }
}

