/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.DependencyAnalyzer;
import org.fuin.units4j.dependency.DependencyError;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.utils4j.Utils4J;

public final class AssertDependencies {
    private AssertDependencies() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    private static void assertIntern(File classesDir, DependencyAnalyzer analyzer) {
        try {
            analyzer.analyze(classesDir);
            List<DependencyError> dependencyErrors = analyzer.getDependencyErrors();
            if (dependencyErrors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < dependencyErrors.size(); ++i) {
                    sb.append(dependencyErrors.get(i));
                    sb.append("\n");
                }
                Assert.fail((String)sb.toString());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void assertRules(Dependencies dependencies, File classesDir) {
        Utils4J.checkNotNull((String)"dependencies", (Object)dependencies);
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        Utils4J.checkValidDir((File)classesDir);
        try {
            DependencyAnalyzer analyzer = new DependencyAnalyzer(dependencies);
            AssertDependencies.assertIntern(classesDir, analyzer);
        }
        catch (InvalidDependenciesDefinitionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void assertRules(File file, File classesDir) {
        Utils4J.checkNotNull((String)"file", (Object)file);
        Utils4J.checkNotNull((String)"classesDir", (Object)classesDir);
        Utils4J.checkValidFile((File)file);
        Utils4J.checkValidDir((File)classesDir);
        try {
            DependencyAnalyzer analyzer = new DependencyAnalyzer(file);
            AssertDependencies.assertIntern(classesDir, analyzer);
        }
        catch (InvalidDependenciesDefinitionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

