/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.units4j.dependency;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.units4j.dependency.Dependencies;
import org.fuin.units4j.dependency.DependencyError;
import org.fuin.units4j.dependency.DependencyVisitor;
import org.fuin.units4j.dependency.DependsOn;
import org.fuin.units4j.dependency.InvalidDependenciesDefinitionException;
import org.fuin.units4j.dependency.NotDependsOn;
import org.fuin.units4j.dependency.Package;
import org.fuin.units4j.dependency.Utils;
import org.fuin.utils4j.Utils4J;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyAnalyzer {
    private final List<DependencyError> dependencyErrors;
    private final Dependencies dependencies;

    public DependencyAnalyzer(File dependenciesFile) throws InvalidDependenciesDefinitionException {
        this(Utils.load(dependenciesFile));
    }

    public DependencyAnalyzer(Dependencies dependencies) throws InvalidDependenciesDefinitionException {
        Utils4J.checkNotNull((String)"dependencies", (Object)dependencies);
        this.dependencies = dependencies;
        this.dependencies.validate();
        this.dependencyErrors = new ArrayList<DependencyError>();
    }

    private void analyzeDir(File classesDir) throws IOException {
        File[] files = classesDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.analyzeDir(files[i]);
            } else if (files[i].getName().endsWith(".class")) {
                this.analyzeClass(files[i]);
            }
            ++i;
        }
    }

    private List<DependencyError> checkIfContainsAll(String className, Package<DependsOn> pkgFound, Set<String> found) {
        List<DependsOn> allowed = pkgFound.getDependencies();
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        Iterator<String> it = found.iterator();
        while (it.hasNext()) {
            DependsOn dep;
            String pkgName = it.next().replace('/', '.');
            if (pkgName.equals(pkgFound.getName()) || this.dependencies.isAlwaysAllowed(pkgName) || (dep = Utils.findByName(allowed, pkgName)) != null) continue;
            errors.add(new DependencyError(className, pkgName, pkgFound.getComment()));
        }
        return errors;
    }

    private List<DependencyError> checkIfNotContainsAny(String className, Package<NotDependsOn> pkgFound, Set<String> found) {
        List<NotDependsOn> forbidden = pkgFound.getDependencies();
        ArrayList<DependencyError> errors = new ArrayList<DependencyError>();
        Iterator<String> it = found.iterator();
        while (it.hasNext()) {
            String pkgName = it.next().replace('/', '.');
            NotDependsOn ndo = Utils.findByName(this.dependencies.getAlwaysForbidden(), pkgName);
            if (ndo != null) {
                errors.add(new DependencyError(className, pkgName, ndo.getComment()));
                continue;
            }
            NotDependsOn dep = Utils.findByName(forbidden, pkgName);
            if (dep == null) continue;
            String comment = dep.getComment() == null ? pkgFound.getComment() : dep.getComment();
            errors.add(new DependencyError(className, pkgName, comment));
        }
        return errors;
    }

    private String nameOnly(String filename) {
        int p = filename.lastIndexOf(46);
        if (p == -1) {
            return filename;
        }
        return filename.substring(0, p);
    }

    private void analyzeClass(File classFile) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(classFile));
        try {
            DependencyVisitor visitor = new DependencyVisitor();
            new ClassReader((InputStream)in).accept((ClassVisitor)visitor, 0);
            Map<String, Map<String, Integer>> globals = visitor.getGlobals();
            Set<String> jarPackages = globals.keySet();
            String pkgName = jarPackages.iterator().next().replace('/', '.');
            String className = String.valueOf(pkgName) + "." + this.nameOnly(classFile.getName());
            int idx = this.dependencies.getAllowed().indexOf(new Package(pkgName));
            if (idx > -1) {
                Package<DependsOn> pkgFound = this.dependencies.getAllowed().get(idx);
                List<DependencyError> errors = this.checkIfContainsAll(className, pkgFound, visitor.getPackages());
                this.dependencyErrors.addAll(errors);
            } else {
                idx = this.dependencies.getForbidden().indexOf(new Package(pkgName));
                if (idx > -1) {
                    Package<NotDependsOn> pkgFound = this.dependencies.getForbidden().get(idx);
                    List<DependencyError> errors = this.checkIfNotContainsAny(className, pkgFound, visitor.getPackages());
                    this.dependencyErrors.addAll(errors);
                }
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public final void analyze(File classesDir) throws IOException {
        this.dependencyErrors.clear();
        this.analyzeDir(classesDir);
    }

    public final List<DependencyError> getDependencyErrors() {
        return this.dependencyErrors;
    }
}

