/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcmixins4j.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.emftext.language.java.JavaClasspath;
import org.emftext.language.java.classifiers.Classifier;
import org.emftext.language.java.resource.JaMoPPUtil;
import org.fuin.srcmixins4j.core.SrcMixins4JAnalyzer;
import org.fuin.srcmixins4j.core.SrcMixins4JAnalyzerContext;
import org.fuin.srcmixins4j.core.SrcMixins4JAnalyzerFileContext;
import org.fuin.srcmixins4j.core.SrcMixins4JUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public final class SrcMixins4JMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(SrcMixins4JMojo.class);
    private ArtifactRepository local;
    private ArtifactFactory factory;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Map errors;
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        JaMoPPUtil.initialize();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.registerJarFiles((ResourceSet)resourceSet);
        List<File> files = this.registerSourceDirectories((ResourceSet)resourceSet);
        SrcMixins4JAnalyzerFileContext context = new SrcMixins4JAnalyzerFileContext(files, (ResourceSet)resourceSet);
        new SrcMixins4JAnalyzer().analyze((SrcMixins4JAnalyzerContext)context);
        Map warnings = context.getWarnings();
        if (warnings.size() > 0) {
            for (Classifier classifier : warnings.keySet()) {
                List messages = (List)warnings.get(classifier);
                for (String message : messages) {
                    LOG.warn(SrcMixins4JUtils.getFullQualifiedName((Classifier)classifier) + ": " + message);
                }
            }
        }
        if ((errors = context.getErrors()).size() > 0) {
            for (Classifier classifier : errors.keySet()) {
                List messages = (List)errors.get(classifier);
                for (String message : messages) {
                    LOG.error(SrcMixins4JUtils.getFullQualifiedName((Classifier)classifier) + ": " + message);
                }
            }
            throw new MojoExecutionException("Couldn't apply mixins - See error log for details");
        }
    }

    private List<File> registerSourceDirectories(ResourceSet resourceSet) throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        List sourceRoots = this.project.getCompileSourceRoots();
        LOG.debug("SourceRoots: " + sourceRoots.size());
        for (String sourceRoot : sourceRoots) {
            LOG.debug("Register source directory: " + sourceRoot);
            JavaClasspath.get((ResourceSet)resourceSet).registerSourceOrClassFileFolder(URI.createFileURI((String)sourceRoot));
            File dir = new File(sourceRoot);
            files.addAll(SrcMixins4JUtils.findRecursiveAllJavaFiles((File)dir));
            try {
                SrcMixins4JUtils.loadResources((ResourceSet)resourceSet, (File)dir);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error retrieving on eof the canonical path", (Exception)ex);
            }
        }
        return files;
    }

    private void registerJarFiles(ResourceSet resourceSet) throws MojoExecutionException {
        File localRepositoryDir = new File(this.local.getBasedir());
        List dependencies = this.project.getDependencies();
        LOG.debug("Dependencies: " + dependencies.size());
        for (Dependency dependency : dependencies) {
            LOG.debug("Dependency: " + dependency);
            Artifact artifact = this.factory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), "jar");
            if ("compile".equals(dependency.getScope())) {
                LOG.debug("Try to find JAR file: " + dependency);
                File file = new File(localRepositoryDir, this.local.pathOf(artifact));
                if (file.exists()) {
                    try {
                        JavaClasspath.get((ResourceSet)resourceSet).registerClassifierJar(URI.createFileURI((String)file.getCanonicalPath()));
                        continue;
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("Error retrieving canonical path: " + file, (Exception)ex);
                    }
                }
                LOG.debug("No JAR file found: " + dependency + " [" + file + "]");
                continue;
            }
            LOG.debug("Ignored scope '" + dependency.getScope() + "': " + dependency);
        }
    }
}

