/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcmixins4j.plugin;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.emftext.language.java.JavaClasspath;
import org.osgi.framework.BundleContext;

public final class SrcMixins4JPlugin
extends Plugin {
    private static SrcMixins4JPlugin plugin;
    private ResourceSet resourceSet = null;
    private IElementChangedListener cpChangeListener;
    private IJavaProject currentProject = null;

    public final void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.cpChangeListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                IJavaElementDelta delta = event.getDelta();
                if ((delta.getFlags() & 0x200000) != 0) {
                    SrcMixins4JPlugin.this.resetClasspath();
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.cpChangeListener);
    }

    public final void stop(BundleContext context) throws Exception {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.cpChangeListener);
        plugin = null;
        this.cpChangeListener = null;
        super.stop(context);
    }

    public static SrcMixins4JPlugin getDefault() {
        return plugin;
    }

    public final ResourceSet getResourceSet(IJavaProject project) {
        if (this.resourceSet == null) {
            System.out.println("Create new ResourceSet");
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getLoadOptions().put("DISABLE_CREATING_MARKERS_FOR_PROBLEMS", Boolean.TRUE);
        }
        if (!project.equals(this.currentProject)) {
            System.out.println("project != currentProject [project=" + SrcMixins4JPlugin.asString(project) + ", currentProject=" + SrcMixins4JPlugin.asString(this.currentProject) + "]");
            this.resetClasspath();
        }
        this.currentProject = project;
        return this.resourceSet;
    }

    private static String asString(IJavaProject project) {
        if (project == null) {
            return "null";
        }
        return String.valueOf(project.getElementName()) + "@" + Integer.toHexString(System.identityHashCode(project));
    }

    public final void resetClasspath() {
        for (Adapter a : this.resourceSet.eAdapters()) {
            if (!(a instanceof JavaClasspath)) continue;
            this.resourceSet.eAdapters().remove((Object)a);
            break;
        }
    }
}

