/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcmixins4j.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.emftext.language.java.annotations.AnnotationInstance;
import org.emftext.language.java.classifiers.Class;
import org.emftext.language.java.classifiers.Classifier;
import org.emftext.language.java.classifiers.ConcreteClassifier;
import org.emftext.language.java.classifiers.Interface;
import org.emftext.language.java.modifiers.AnnotableAndModifiable;
import org.emftext.language.java.resource.java.mopp.JavaMarkerHelper;
import org.fuin.srcmixins4j.annotations.MixinProvider;
import org.fuin.srcmixins4j.core.SrcMixins4JAnalyzerContext;
import org.fuin.srcmixins4j.core.SrcMixins4JUtils;

public final class SrcMixins4JAnalyzerEclipseContext
implements SrcMixins4JAnalyzerContext {
    private final IJavaProject project;
    private final ResourceSet resourceSet;
    private final BuildContext[] buildContexts;
    private int idx = -1;
    private BuildContext buildContext;

    public SrcMixins4JAnalyzerEclipseContext(IJavaProject project, BuildContext[] buildContexts, ResourceSet resourceSet) {
        if (project == null) {
            throw new IllegalArgumentException("project == null");
        }
        if (buildContexts == null) {
            throw new IllegalArgumentException("buildContexts == null");
        }
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet == null");
        }
        this.project = project;
        this.buildContexts = buildContexts;
        this.resourceSet = resourceSet;
    }

    public final ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public final boolean hasNextResource() {
        return this.idx < this.buildContexts.length - 1;
    }

    public final Resource nextResource() {
        if (this.idx == this.buildContexts.length - 1) {
            throw new NoSuchElementException("There are no more resources!");
        }
        this.buildContext = this.buildContexts[++this.idx];
        return this.loadResource(this.buildContext.getFile());
    }

    public final void markResourceAsChanged() {
        if (this.buildContext == null) {
            throw new IllegalStateException("nextResource() has not yet been called");
        }
        this.buildContext.recordAddedGeneratedFiles(new IFile[]{this.buildContext.getFile()});
    }

    public final Class findMixinProvider(Interface mixinIntf) {
        if (mixinIntf == null) {
            throw new IllegalArgumentException("mixinIntf == null");
        }
        SearchPattern mixinImpl = SearchPattern.createPattern((String)MixinProvider.class.getName(), (int)8, (int)65536, (int)0);
        List<IType> types = SrcMixins4JAnalyzerEclipseContext.findSourceTypes(mixinImpl, new IJavaElement[]{this.project});
        for (IType type : types) {
            Class clasz;
            AnnotationInstance ai;
            Interface intf;
            ConcreteClassifier cc = mixinIntf.getConcreteClassifier(type.getFullyQualifiedName());
            if (!(cc instanceof Class) || (intf = SrcMixins4JUtils.getSingleAnnotationInterfaceParameter((AnnotationInstance)(ai = SrcMixins4JUtils.getAnnotationInstance((AnnotableAndModifiable)(clasz = (Class)cc), (String)MixinProvider.class.getName())))) != mixinIntf) continue;
            return clasz;
        }
        return null;
    }

    public final List<Class> findMixinUsers(Interface mixinIntf) {
        if (mixinIntf == null) {
            throw new IllegalArgumentException("mixinIntf == null");
        }
        String mixinIntfName = SrcMixins4JUtils.getFullQualifiedName((Classifier)mixinIntf);
        SearchPattern mixinUsers = SearchPattern.createPattern((String)mixinIntfName, (int)5, (int)1, (int)0);
        ArrayList<Class> list = new ArrayList<Class>();
        List<IType> types = SrcMixins4JAnalyzerEclipseContext.findSourceTypes(mixinUsers, new IJavaElement[]{this.project});
        for (IType type : types) {
            ConcreteClassifier cc = mixinIntf.getConcreteClassifier(type.getFullyQualifiedName());
            if (!(cc instanceof Class)) continue;
            list.add((Class)cc);
        }
        return list;
    }

    private static List<IType> findSourceTypes(SearchPattern searchPattern, IJavaElement ... elements) {
        ArrayList<IType> resultList = new ArrayList<IType>();
        SearchRequestor requestor = SrcMixins4JAnalyzerEclipseContext.createRequestor(resultList);
        try {
            new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)1), requestor, null);
        }
        catch (CoreException ex) {
            throw new RuntimeException("Error trying to find source types", ex);
        }
        return resultList;
    }

    private static SearchRequestor createRequestor(final List<IType> resultList) {
        return new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    resultList.add((IType)element);
                }
            }
        };
    }

    private Resource loadResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = this.resourceSet.getResource(uri, false);
        if (resource != null) {
            resource.unload();
            new JavaMarkerHelper().unmark(resource);
        }
        resource = this.resourceSet.getResource(uri, true);
        return resource;
    }
}

