/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgConstructor;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgClass {
    public static final SgClass VOID = new SgClass("", "", "void", false, null);
    public static final SgClass BOOLEAN = new SgClass("", "", "boolean", false, null);
    public static final SgClass BYTE = new SgClass("", "", "byte", false, null);
    public static final SgClass CHAR = new SgClass("", "", "char", false, null);
    public static final SgClass SHORT = new SgClass("", "", "short", false, null);
    public static final SgClass INT = new SgClass("", "", "int", false, null);
    public static final SgClass LONG = new SgClass("", "", "long", false, null);
    public static final SgClass FLOAT = new SgClass("", "", "float", false, null);
    public static final SgClass DOUBLE = new SgClass("", "", "double", false, null);
    public static final SgClass OBJECT = new SgClass("", "", "Object", false, null);
    private final String modifiers;
    private final String packageName;
    private final String simpleName;
    private final List<SgClass> interfaces;
    private final List<SgField> fields;
    private final boolean isinterface;
    private final SgClass superClass;
    private final List<SgConstructor> constructors;
    private final List<SgMethod> methods;
    private final List<SgClass> classes;
    private final SgClass enclosingClass;
    private final List<SgAnnotation> annotations;

    public SgClass(String packageName, String simpleName) {
        this("public", packageName, simpleName, null, false, null);
    }

    public SgClass(String modifiers, String packageName, String simpleName, boolean isinterface, SgClass enclosingClass) {
        this(modifiers, packageName, simpleName, null, isinterface, enclosingClass);
    }

    public SgClass(String modifiers, String packageName, String simpleName, SgClass superClass, boolean isinterface, SgClass enclosingClass) {
        this.modifiers = modifiers;
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.superClass = superClass;
        if (isinterface && superClass != null) {
            throw new IllegalArgumentException("This is an interface. You cannot set a super class. Use 'addInterface(SgClass)' instead!");
        }
        this.constructors = new ArrayList<SgConstructor>();
        this.methods = new ArrayList<SgMethod>();
        this.interfaces = new ArrayList<SgClass>();
        this.fields = new ArrayList<SgField>();
        this.isinterface = isinterface;
        this.classes = new ArrayList<SgClass>();
        this.annotations = new ArrayList<SgAnnotation>();
        this.enclosingClass = enclosingClass;
        if (enclosingClass != null) {
            this.enclosingClass.addClass(this);
        }
    }

    public final List<SgAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public final void addAnnotation(SgAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("The argument 'annotation' cannot be NULL!");
        }
        this.annotations.add(annotation);
    }

    public final void addAnnotations(List<SgAnnotation> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("The argument 'annotations' cannot be NULL!");
        }
        this.annotations.addAll(annotations);
    }

    public final boolean hasAnnotation(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            SgAnnotation annotation = this.annotations.get(i);
            if (!annotation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final SgClass getSuperClass() {
        return this.superClass;
    }

    public final String getSimpleNameAsPackage() {
        return SgUtils.uppercaseToUnderscore(this.getSimpleName());
    }

    public final List<SgConstructor> getConstructors() {
        return Collections.unmodifiableList(this.constructors);
    }

    public final void addConstructor(SgConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("The argument 'constructor' cannot be null!");
        }
        if (constructor.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'constructor' is different from 'this'!");
        }
        if (!this.constructors.contains(constructor)) {
            this.constructors.add(constructor);
        }
    }

    public final boolean isInterface() {
        return this.isinterface;
    }

    public final List<SgMethod> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public final void addMethod(SgMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("The argument 'method' cannot be null!");
        }
        if (method.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'method' is different from 'this'!");
        }
        if (!this.methods.contains(method)) {
            this.methods.add(method);
        }
    }

    public final String getName() {
        return this.getName("$");
    }

    public final String getSourceName() {
        return this.getName(".");
    }

    public final String getNameAsFilename() {
        return this.getName().replace('.', File.separatorChar);
    }

    public final String getNameAsSrcFilename() {
        return this.getNameAsFilename() + ".java";
    }

    public final String getNameAsBinFilename() {
        return this.getNameAsFilename() + ".class";
    }

    private String getEnclosingSimpleNames(String innerDivider) {
        StringBuffer sb = new StringBuffer();
        for (SgClass clasz = this.enclosingClass; clasz != null; clasz = clasz.getEnclosingClass()) {
            sb.insert(0, innerDivider);
            sb.insert(0, clasz.getSimpleName());
        }
        return sb.toString();
    }

    private final String getName(String innerDivider) {
        if (this.packageName.length() == 0) {
            if (this.enclosingClass == null) {
                return this.simpleName;
            }
            return this.getEnclosingSimpleNames(innerDivider) + this.simpleName;
        }
        if (this.enclosingClass == null) {
            return this.packageName + "." + this.simpleName;
        }
        return this.packageName + "." + this.getEnclosingSimpleNames(innerDivider) + this.simpleName;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final List<SgClass> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public final void addInterface(SgClass intf) {
        if (intf == null) {
            throw new IllegalArgumentException("The argument 'intf' cannot be null!");
        }
        this.interfaces.add(intf);
    }

    public final String getInterfacesCommaSeparated() {
        StringBuffer sb = new StringBuffer();
        if (this.interfaces.size() > 0) {
            for (int i = 0; i < this.interfaces.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.interfaces.get(i).getSourceName());
            }
        }
        return sb.toString();
    }

    public final List<SgField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public final void addField(SgField field) {
        if (field == null) {
            throw new IllegalArgumentException("The argument 'field' cannot be null!");
        }
        if (field.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'field' is different from 'this'!");
        }
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public final List<SgClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public final void addClass(SgClass clasz) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        if (!this.classes.contains(clasz)) {
            this.classes.add(clasz);
        }
    }

    public final SgClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public final SgClass findClassByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            SgClass clasz = this.classes.get(i);
            if (!clasz.getName().equals(name)) continue;
            return clasz;
        }
        return null;
    }

    public final SgMethod findMethodByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            SgMethod method = this.methods.get(i);
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public final SgField findFieldByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            SgField field = this.fields.get(i);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private void addPackageLine(StringBuffer sb) {
        if (this.enclosingClass == null && this.packageName.length() > 0) {
            sb.append("package ");
            sb.append(this.packageName);
            sb.append(";\n");
            sb.append("\n");
        }
    }

    private void addNameLine(StringBuffer sb, boolean showAnnotations) {
        if (showAnnotations && this.getAnnotations().size() > 0) {
            for (int i = 0; i < this.getAnnotations().size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.getAnnotations().get(i));
            }
            sb.append("\n");
        }
        if (this.modifiers.length() > 0) {
            sb.append(this.modifiers);
            sb.append(" ");
        }
        if (this.isinterface) {
            sb.append("interface ");
        } else {
            sb.append("class ");
        }
        sb.append(this.getSimpleName());
        if (this.isinterface) {
            if (this.interfaces.size() > 0) {
                sb.append(" extends ");
                sb.append(this.getInterfacesCommaSeparated());
            }
        } else {
            if (this.superClass != null && !"Object".equals(this.superClass.getName())) {
                sb.append(" extends ");
                sb.append(this.superClass.getSourceName());
            }
            if (this.interfaces.size() > 0) {
                sb.append(" implements ");
                sb.append(this.getInterfacesCommaSeparated());
            }
        }
        sb.append(" {\n");
    }

    private void addFields(StringBuffer sb) {
        for (int i = 0; i < this.getFields().size(); ++i) {
            sb.append(this.getFields().get(i) + "\n");
            sb.append("\n");
        }
        sb.append("\n");
    }

    private void addConstructors(StringBuffer sb) {
        for (int i = 0; i < this.constructors.size(); ++i) {
            sb.append(this.constructors.get(i) + "\n");
            sb.append("\n");
        }
        sb.append("\n");
    }

    private void addMethods(StringBuffer sb) {
        for (int i = 0; i < this.methods.size(); ++i) {
            sb.append(this.methods.get(i) + "\n");
            sb.append("\n");
        }
    }

    private void addInnerClasses(StringBuffer sb) {
        for (int i = 0; i < this.classes.size(); ++i) {
            sb.append(this.classes.get(i) + "\n");
        }
        sb.append("}\n");
    }

    public final String getModifiers() {
        return this.modifiers;
    }

    public final boolean isPrimitive() {
        return this.equals(VOID) || this.equals(BOOLEAN) || this.equals(BYTE) || this.equals(CHAR) || this.equals(SHORT) || this.equals(INT) || this.equals(LONG) || this.equals(FLOAT) || this.equals(DOUBLE);
    }

    public final boolean isBaseType() {
        String name = this.getName();
        if (name.equals(String.class.getName())) {
            return true;
        }
        if (name.equals(Boolean.class.getName())) {
            return true;
        }
        if (name.equals(Byte.class.getName())) {
            return true;
        }
        if (name.equals(Character.class.getName())) {
            return true;
        }
        if (name.equals(Short.class.getName())) {
            return true;
        }
        if (name.equals(Integer.class.getName())) {
            return true;
        }
        if (name.equals(Long.class.getName())) {
            return true;
        }
        if (name.equals(Float.class.getName())) {
            return true;
        }
        if (name.equals(Double.class.getName())) {
            return true;
        }
        if (name.equals(BigDecimal.class.getName())) {
            return true;
        }
        return name.equals(BigInteger.class.getName());
    }

    public final boolean hasInterface(SgClass intf) {
        if (intf == null) {
            throw new IllegalArgumentException("The argument 'intf' cannot be null!");
        }
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("The argument 'intf' is a class an not an interface!");
        }
        for (int i = 0; i < this.interfaces.size(); ++i) {
            if (!this.interfaces.get(i).equals(intf)) continue;
            return true;
        }
        if (this.superClass != null) {
            return this.superClass.hasInterface(intf);
        }
        return false;
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean showAnnotations) {
        StringBuffer sb = new StringBuffer();
        this.addPackageLine(sb);
        this.addNameLine(sb, showAnnotations);
        this.addFields(sb);
        this.addConstructors(sb);
        this.addMethods(sb);
        this.addInnerClasses(sb);
        return sb.toString();
    }

    public static SgClass create(SgClassPool pool, String className) {
        if (pool == null) {
            throw new IllegalArgumentException("The argument 'pool' cannot be null!");
        }
        if (className == null) {
            throw new IllegalArgumentException("The argument 'className' cannot be null!");
        }
        SgClass cached = pool.get(className);
        if (cached != null) {
            return cached;
        }
        try {
            return SgClass.create(pool, Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot create '" + className + "'!", e);
        }
    }

    public static SgClass create(SgClassPool pool, Class<?> clasz) {
        if (pool == null) {
            throw new IllegalArgumentException("The argument 'pool' cannot be null!");
        }
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        SgClass cached = pool.get(clasz.getName());
        if (cached != null) {
            return cached;
        }
        try {
            SgClass cl = SgClass.createClass(pool, clasz);
            SgClass.addInterfaces(pool, cl, clasz);
            SgClass.addFields(pool, cl, clasz);
            SgClass.addConstructors(pool, cl, clasz);
            SgClass.addMethods(pool, cl, clasz);
            SgClass.addInnerClasses(pool, cl, clasz);
            return cl;
        }
        catch (RuntimeException ex) {
            System.out.println("ERROR CLASS: " + clasz);
            throw ex;
        }
    }

    private static SgClass createClass(SgClassPool pool, Class<?> clasz) {
        SgClass enclosingClass = clasz.getEnclosingClass() == null ? null : SgClass.create(pool, clasz.getEnclosingClass());
        String clModifiers = Modifier.toString(clasz.getModifiers());
        String packageName = clasz.getPackage() == null ? "" : clasz.getPackage().getName();
        SgClass superClass = clasz.isInterface() ? null : SgClass.create(pool, clasz.getSuperclass());
        SgClass cl = new SgClass(clModifiers, packageName, clasz.getSimpleName(), superClass, clasz.isInterface(), enclosingClass);
        if (clasz.isArray()) {
            pool.put(clasz.getName(), cl);
        } else {
            pool.put(cl);
        }
        return cl;
    }

    private static void addInterfaces(SgClassPool pool, SgClass cl, Class<?> clasz) {
        Class<?>[] interfaces = clasz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            cl.addInterface(SgClass.create(pool, interfaces[i]));
        }
    }

    private static void addFields(SgClassPool pool, SgClass cl, Class<?> clasz) {
        Field[] fields = clasz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            SgClass type = SgClass.create(pool, fields[i].getType());
            String name = fields[i].getName();
            String modifiers = Modifier.toString(fields[i].getModifiers());
            SgField field = new SgField(cl, modifiers, type, name, null);
            field.addAnnotations(SgUtils.createAnnotations(fields[i].getAnnotations()));
        }
    }

    private static void addConstructors(SgClassPool pool, SgClass cl, Class<?> clasz) {
        if (!cl.isInterface()) {
            Constructor<?>[] constructors = clasz.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                SgConstructor constructor = new SgConstructor(cl, Modifier.toString(constructors[i].getModifiers()));
                Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                for (int j = 0; j < parameterTypes.length; ++j) {
                    new SgArgument(constructor, SgClass.create(pool, parameterTypes[j]), "p" + j);
                }
                Class<?>[] exceptions = constructors[i].getExceptionTypes();
                for (int j = 0; j < exceptions.length; ++j) {
                    constructor.addException(SgClass.create(pool, clasz));
                }
                cl.addConstructor(constructor);
            }
        }
    }

    private static void addMethods(SgClassPool pool, SgClass cl, Class<?> clasz) {
        Method[] methods = clasz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String mModifiers = Modifier.toString(methods[i].getModifiers());
            SgClass returnType = SgClass.create(pool, methods[i].getReturnType());
            SgMethod method = new SgMethod(cl, mModifiers, returnType, methods[i].getName());
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                new SgArgument(method, SgClass.create(pool, parameterTypes[j]), "p" + j);
            }
            method.addAnnotations(SgUtils.createAnnotations(methods[i].getAnnotations()));
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            for (int j = 0; j < exceptions.length; ++j) {
                method.addException(SgClass.create(pool, clasz));
            }
            cl.addMethod(method);
        }
    }

    private static void addInnerClasses(SgClassPool pool, SgClass cl, Class<?> clasz) {
        Class<?>[] innerClasses = clasz.getClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            cl.addClass(SgClass.create(pool, innerClasses[i]));
        }
    }

    public static final SgClass getNonPrimitiveClass(SgClassPool pool, SgClass primitive) {
        if (primitive.equals(BOOLEAN)) {
            return SgClass.create(pool, Boolean.class);
        }
        if (primitive.equals(BYTE)) {
            return SgClass.create(pool, Byte.class);
        }
        if (primitive.equals(CHAR)) {
            return SgClass.create(pool, Character.class);
        }
        if (primitive.equals(SHORT)) {
            return SgClass.create(pool, Short.class);
        }
        if (primitive.equals(INT)) {
            return SgClass.create(pool, Integer.class);
        }
        if (primitive.equals(LONG)) {
            return SgClass.create(pool, Long.class);
        }
        if (primitive.equals(FLOAT)) {
            return SgClass.create(pool, Float.class);
        }
        if (primitive.equals(DOUBLE)) {
            return SgClass.create(pool, Double.class);
        }
        throw new IllegalArgumentException("No primitive or 'void' class: '" + primitive.getName() + "'!");
    }

    public static final String getToPrimitiveMethod(SgClass clasz) {
        String name = clasz.getName();
        if (name.equals(Boolean.class.getName())) {
            return "booleanValue";
        }
        if (name.equals(Byte.class.getName())) {
            return "byteValue";
        }
        if (name.equals(Character.class.getName())) {
            return "charValue";
        }
        if (name.equals(Short.class.getName())) {
            return "shortValue";
        }
        if (name.equals(Integer.class.getName())) {
            return "intValue";
        }
        if (name.equals(Long.class.getName())) {
            return "longValue";
        }
        if (name.equals(Float.class.getName())) {
            return "floatValue";
        }
        if (name.equals(Double.class.getName())) {
            return "doubleValue";
        }
        throw new IllegalArgumentException("Cannot convert '" + clasz.getName() + "' to a primitive type!");
    }
}

