/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgAnnotation {
    private final String packageName;
    private final String simpleName;
    private final Map<String, Object> arguments;

    public SgAnnotation(String packageName, String simpleName) {
        if (packageName == null) {
            throw new IllegalArgumentException("The argument 'packageName' cannot be null!");
        }
        this.packageName = packageName.trim();
        if (simpleName == null) {
            throw new IllegalArgumentException("The argument 'simpleName' cannot be null!");
        }
        String trimmed = simpleName.trim();
        if (trimmed.length() == 0) {
            throw new IllegalArgumentException("The argument 'simpleName' cannot be an empty string!");
        }
        this.simpleName = trimmed;
        this.arguments = new HashMap<String, Object>();
    }

    public final String getName() {
        if (this.packageName.length() == 0) {
            return this.simpleName;
        }
        return this.packageName + "." + this.simpleName;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final Map<String, Object> getArguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public final void addArgument(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument 'value' cannot be null!");
        }
        this.arguments.put(name.trim(), value);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        sb.append(this.getName());
        if (this.arguments.size() > 0) {
            sb.append("(");
            if (this.arguments.size() == 1) {
                for (String name : this.arguments.keySet()) {
                    Object value = this.arguments.get(name);
                    if (!name.equals("value")) {
                        sb.append(name);
                        sb.append("=");
                    }
                    sb.append(value);
                }
            } else {
                int count = 0;
                for (String name : this.arguments.keySet()) {
                    Object value = this.arguments.get(name);
                    if (count > 0) {
                        sb.append(", ");
                    }
                    sb.append(name);
                    sb.append("=");
                    sb.append(value);
                    ++count;
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

