/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgUtils {
    private static final String CLASS_ABSTRACT_AND_FINAL_ERROR = "Classes cannot be declared abstract and final simultaneously!";
    private static final String METHOD_ACCESS_MODIFIER_ERROR = "A method declaration can contain only one of the access modifiers public, package, protected and private!";
    private static final String METHOD_ILLEGAL_ABSTRACT_MODIFIERS_ERROR = "Abstract methods cannot be declared private, static, final, native, strictfp or synchronized!";
    private static final String METHOD_NATIVE_STRICTFP_ERROR = "Methods cannot be declared native and strictfp simultaneously!";
    private static final String FIELD_FINAL_VOLATILE_ERROR = "Final fields cannot be volatile!";
    private static final int FIELD = 0;
    private static final int METHOD = 1;
    private static final int CONSTRUCTOR = 2;
    private static final int OUTER_CLASS = 3;
    private static final int INNER_CLASS = 4;
    private static final int OUTER_INTERFACE = 5;
    private static final int INNER_INTERFACE = 6;
    private static final String[] TYPE_NAMES = new String[]{"Field", "Method", "Constructor", "Outer Class", "Inner Class", "Outer Interface", "Inner Interface"};
    private static final int ABSTRACT = 0;
    private static final int FINAL = 1;
    private static final int NATIVE = 2;
    private static final int PRIVATE = 3;
    private static final int PROTECTED = 4;
    private static final int PUBLIC = 5;
    private static final int STATIC = 6;
    private static final int SYNCHRONIZED = 7;
    private static final int TRANSIENT = 8;
    private static final int VOLATILE = 9;
    private static final int STRICTFP = 10;
    private static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "native", "private", "protected", "public", "static", "synchronized", "transient", "volatile", "strictfp"};
    private static final int[] MODIFIER_VALUES = new int[]{1024, 16, 256, 2, 4, 1, 8, 32, 128, 64, 2048};
    private static final boolean[][] MODIFIERS_MATRIX;

    static {
        boolean[][] blArrayArray = new boolean[11][];
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[7];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[7];
        blArray3[1] = true;
        blArrayArray[2] = blArray3;
        boolean[] blArray4 = new boolean[7];
        blArray4[0] = true;
        blArray4[1] = true;
        blArray4[2] = true;
        blArray4[4] = true;
        blArray4[6] = true;
        blArrayArray[3] = blArray4;
        boolean[] blArray5 = new boolean[7];
        blArray5[0] = true;
        blArray5[1] = true;
        blArray5[2] = true;
        blArray5[4] = true;
        blArray5[6] = true;
        blArrayArray[4] = blArray5;
        blArrayArray[5] = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray6 = new boolean[7];
        blArray6[0] = true;
        blArray6[1] = true;
        blArray6[4] = true;
        blArray6[6] = true;
        blArrayArray[6] = blArray6;
        boolean[] blArray7 = new boolean[7];
        blArray7[1] = true;
        blArrayArray[7] = blArray7;
        boolean[] blArray8 = new boolean[7];
        blArray8[0] = true;
        blArrayArray[8] = blArray8;
        boolean[] blArray9 = new boolean[7];
        blArray9[0] = true;
        blArrayArray[9] = blArray9;
        boolean[] blArray10 = new boolean[7];
        blArray10[1] = true;
        blArray10[3] = true;
        blArray10[4] = true;
        blArray10[5] = true;
        blArray10[6] = true;
        blArrayArray[10] = blArray10;
        MODIFIERS_MATRIX = blArrayArray;
    }

    private SgUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of this class!");
    }

    private static void throwIllegalArgument(int type, int modifier) {
        throw new IllegalArgumentException("The modifier '" + MODIFIER_NAMES[modifier] + "' is not allowed for '" + TYPE_NAMES[type] + "'!");
    }

    private static void checkModifiers(int type, int modifiers) {
        int modifier = 0;
        while (modifier <= 10) {
            if (Modifier.isPrivate(modifiers) && !MODIFIERS_MATRIX[3][type]) {
                SgUtils.throwIllegalArgument(type, 3);
            }
            if (Modifier.isProtected(modifiers) && !MODIFIERS_MATRIX[4][type]) {
                SgUtils.throwIllegalArgument(type, 4);
            }
            if (Modifier.isPublic(modifiers) && !MODIFIERS_MATRIX[5][type]) {
                SgUtils.throwIllegalArgument(type, 5);
            }
            if (Modifier.isStatic(modifiers) && !MODIFIERS_MATRIX[6][type]) {
                SgUtils.throwIllegalArgument(type, 6);
            }
            if (Modifier.isAbstract(modifiers) && !MODIFIERS_MATRIX[0][type]) {
                SgUtils.throwIllegalArgument(type, 0);
            }
            if (Modifier.isFinal(modifiers) && !MODIFIERS_MATRIX[1][type]) {
                SgUtils.throwIllegalArgument(type, 1);
            }
            if (Modifier.isNative(modifiers) && !MODIFIERS_MATRIX[2][type]) {
                SgUtils.throwIllegalArgument(type, 2);
            }
            if (Modifier.isSynchronized(modifiers) && !MODIFIERS_MATRIX[7][type]) {
                SgUtils.throwIllegalArgument(type, 7);
            }
            if (Modifier.isTransient(modifiers) && !MODIFIERS_MATRIX[8][type]) {
                SgUtils.throwIllegalArgument(type, 8);
            }
            if (Modifier.isVolatile(modifiers) && !MODIFIERS_MATRIX[9][type]) {
                SgUtils.throwIllegalArgument(type, 9);
            }
            if (Modifier.isStrict(modifiers) && !MODIFIERS_MATRIX[10][type]) {
                SgUtils.throwIllegalArgument(type, 10);
            }
            ++modifier;
        }
    }

    public static void checkClassModifiers(int modifiers, boolean isInterface, boolean isInnerClass) {
        int type = isInterface ? (isInnerClass ? 6 : 5) : (isInnerClass ? 4 : 3);
        SgUtils.checkModifiers(type, modifiers);
        if (Modifier.isAbstract(modifiers) && Modifier.isFinal(modifiers)) {
            throw new IllegalArgumentException("Classes cannot be declared abstract and final simultaneously! [" + Modifier.toString(modifiers) + "]");
        }
    }

    public static void checkFieldModifiers(int modifiers) {
        SgUtils.checkModifiers(0, modifiers);
        if (Modifier.isFinal(modifiers) && Modifier.isVolatile(modifiers)) {
            throw new IllegalArgumentException("Final fields cannot be volatile! [" + Modifier.toString(modifiers) + "]");
        }
    }

    public static void checkMethodModifiers(int modifiers) {
        SgUtils.checkModifiers(1, modifiers);
        if (Modifier.isPrivate(modifiers) && (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
            throw new IllegalArgumentException("A method declaration can contain only one of the access modifiers public, package, protected and private! [" + Modifier.toString(modifiers) + "]");
        }
        if (Modifier.isProtected(modifiers) && (Modifier.isPrivate(modifiers) || Modifier.isPublic(modifiers))) {
            throw new IllegalArgumentException("A method declaration can contain only one of the access modifiers public, package, protected and private! [" + Modifier.toString(modifiers) + "]");
        }
        if (Modifier.isPublic(modifiers) && (Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers))) {
            throw new IllegalArgumentException("A method declaration can contain only one of the access modifiers public, package, protected and private! [" + Modifier.toString(modifiers) + "]");
        }
        if (Modifier.isAbstract(modifiers) && (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isNative(modifiers) || Modifier.isStrict(modifiers) || Modifier.isSynchronized(modifiers))) {
            throw new IllegalArgumentException("Abstract methods cannot be declared private, static, final, native, strictfp or synchronized! [" + Modifier.toString(modifiers) + "]");
        }
        if (Modifier.isNative(modifiers) && Modifier.isStrict(modifiers)) {
            throw new IllegalArgumentException("Methods cannot be declared native and strictfp simultaneously! [" + Modifier.toString(modifiers) + "]");
        }
    }

    public static void checkConstructorModifiers(int modifiers) {
        SgUtils.checkModifiers(2, modifiers);
    }

    public static String uppercaseToUnderscore(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(Character.toLowerCase(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    public static String concatPackages(String package1, String package2) {
        if (package1 == null || package1.length() == 0) {
            if (package2 == null || package2.length() == 0) {
                return "";
            }
            return package2;
        }
        if (package2 == null || package2.length() == 0) {
            return package1;
        }
        return String.valueOf(package1) + "." + package2;
    }

    public static void addToStringMethod(SgClassPool pool, SgClass clasz, List<SgField> fields) {
        SgMethod m = new SgMethod(clasz, "public", SgClass.create(pool, String.class), "toString");
        m.addBodyLine("return getClass().getSimpleName() + \"{\"");
        int i = 0;
        while (i < fields.size()) {
            SgField field = fields.get(i);
            String nameValue = " + \"" + field.getName() + "=\" + " + field.getName();
            if (i < fields.size() - 1) {
                m.addBodyLine(String.valueOf(nameValue) + " + \", \"");
            } else {
                m.addBodyLine(nameValue);
            }
            ++i;
        }
        m.addBodyLine(" + \"}\";");
        clasz.addMethod(m);
    }

    public static String modifierMatrixToHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\">\n");
        sb.append("<tr>");
        sb.append("<th>&nbsp;</th>");
        int type = 0;
        while (type <= 6) {
            sb.append("<th>");
            sb.append(TYPE_NAMES[type]);
            sb.append("</th>");
            ++type;
        }
        sb.append("</tr>\n");
        int modifier = 0;
        while (modifier <= 10) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append(MODIFIER_NAMES[modifier]);
            sb.append("</td>");
            int type2 = 0;
            while (type2 <= 6) {
                sb.append("<td>");
                sb.append(MODIFIERS_MATRIX[modifier][type2]);
                sb.append("</td>");
                ++type2;
            }
            sb.append("</tr>\n");
            ++modifier;
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    private static int modifierValueForName(String name) {
        int i = 0;
        while (i < MODIFIER_NAMES.length) {
            if (name.equals(MODIFIER_NAMES[i])) {
                return MODIFIER_VALUES[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown modifier '" + name + "'!");
    }

    public static int toModifiers(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        String trimmedModifiers = modifiers.trim();
        int modifier = 0;
        StringTokenizer tok = new StringTokenizer(trimmedModifiers, " ");
        while (tok.hasMoreTokens()) {
            String mod = tok.nextToken();
            modifier |= SgUtils.modifierValueForName(mod);
        }
        return modifier;
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (SgUtils.isEmpty(text) || SgUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int maxx = max;
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= maxx < 0 ? 16 : (maxx > 64 ? 64 : maxx)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--maxx == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String createTypeSignature(String methodName, Class<?>[] paramTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append(methodName);
        sb.append("(");
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramTypes[i].getSimpleName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static List<SgAnnotation> createAnnotations(Annotation[] ann) {
        ArrayList<SgAnnotation> list = new ArrayList<SgAnnotation>();
        if (ann != null && ann.length > 0) {
            int i = 0;
            while (i < ann.length) {
                SgAnnotation annotation = new SgAnnotation(ann[i].annotationType().getPackage().getName(), ann[i].annotationType().getSimpleName());
                list.add(annotation);
                ++i;
            }
        }
        return list;
    }
}

