/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgBehavior;
import org.fuin.srcgen4javassist.SgClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgConstructor
extends SgBehavior {
    private final List<String> body = new ArrayList<String>();

    public SgConstructor(SgClass owner) {
        this(owner, "public");
    }

    public SgConstructor(SgClass owner, String modifiers) {
        super(owner, modifiers);
        owner.addConstructor(this);
    }

    public final List<String> getBody() {
        return Collections.unmodifiableList(this.body);
    }

    public final void addBodyLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("The argument 'line' cannot be null!");
        }
        this.body.add(line);
    }

    public final String getSignature() {
        StringBuffer sb = new StringBuffer();
        if (this.getModifiers().length() > 0) {
            sb.append(this.getModifiers());
            sb.append(" ");
        }
        sb.append(this.getOwner().getSimpleName());
        sb.append("(");
        int i = 0;
        while (i < this.getArguments().size()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getArguments().get(i));
            ++i;
        }
        sb.append(")");
        if (this.getExceptions().size() > 0) {
            sb.append(" throws ");
            i = 0;
            while (i < this.getExceptions().size()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.getExceptions().get(i).getName());
                ++i;
            }
        }
        return sb.toString();
    }

    public final String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.getAnnotations().size() > 0) {
            i = 0;
            while (i < this.getAnnotations().size()) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.getAnnotations().get(i));
                ++i;
            }
            sb.append("\n");
        }
        sb.append(this.getSignature());
        if (this.getOwner().isInterface()) {
            sb.append(";");
        } else {
            sb.append("{\n");
            if (this.body.size() == 0) {
                sb.append("// No method source available\n");
            } else {
                i = 0;
                while (i < this.body.size()) {
                    sb.append(this.body.get(i));
                    sb.append("\n");
                    ++i;
                }
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

