/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SgBehavior {
    private final SgClass owner;
    private final String modifiers;
    private final List<SgArgument> arguments;
    private final List<SgClass> exceptions;
    private final List<SgAnnotation> annotations;

    public SgBehavior(SgClass owner, String modifiers) {
        if (owner == null) {
            throw new IllegalArgumentException("The argument 'owner' cannot be null!");
        }
        this.owner = owner;
        if (modifiers == null) {
            throw new IllegalArgumentException("The argument 'modifiers' cannot be null!");
        }
        this.modifiers = modifiers;
        this.arguments = new ArrayList<SgArgument>();
        this.exceptions = new ArrayList<SgClass>();
        this.annotations = new ArrayList<SgAnnotation>();
    }

    public final SgClass getOwner() {
        return this.owner;
    }

    public final String getModifiers() {
        return this.modifiers;
    }

    public final List<SgArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    private static final String commaSeparated(List<SgArgument> args) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args.get(i).getName());
            ++i;
        }
        return sb.toString();
    }

    public final String getCommaSeparatedArgumentNames(int less) {
        List<SgArgument> args = this.getArguments(less);
        return SgBehavior.commaSeparated(args);
    }

    public final String getCommaSeparatedArgumentNames() {
        return SgBehavior.commaSeparated(this.arguments);
    }

    public final List<SgArgument> getArguments(int less) {
        if (less >= 0) {
            throw new IllegalArgumentException("Only negative values are allowed! [" + less + "]");
        }
        int count = this.arguments.size() + less;
        if (count < 0) {
            throw new IllegalArgumentException("There are only " + this.arguments.size() + " arguments! Subtracting '" + less + "' would be below zero!");
        }
        ArrayList<SgArgument> list = new ArrayList<SgArgument>();
        int i = 0;
        while (i < count) {
            list.add(this.arguments.get(i));
            ++i;
        }
        return Collections.unmodifiableList(list);
    }

    public final SgArgument getLastArgument() {
        int size = this.arguments.size();
        if (size == 0) {
            return null;
        }
        return this.arguments.get(size - 1);
    }

    public final void addArgument(SgArgument arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The argument 'arg' cannot be null!");
        }
        if (arg.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'arg' is different from 'this'!");
        }
        if (!this.arguments.contains(arg)) {
            this.arguments.add(arg);
        }
    }

    public final List<SgClass> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public final void addException(SgClass clasz) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        if (!this.exceptions.contains(clasz)) {
            this.exceptions.add(clasz);
        }
    }

    public final List<SgAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public final void addAnnotation(SgAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("The argument 'annotation' cannot be NULL!");
        }
        this.annotations.add(annotation);
    }

    public final void addAnnotations(List<SgAnnotation> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("The argument 'annotations' cannot be NULL!");
        }
        this.annotations.addAll(annotations);
    }

    public final boolean hasAnnotation(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        int i = 0;
        while (i < this.annotations.size()) {
            SgAnnotation annotation = this.annotations.get(i);
            if (annotation.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

