/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist.factory;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;
import org.fuin.srcgen4javassist.factory.ImplementedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationFactory {
    private final boolean onlyDeclaredMethods;
    private final SgClassPool pool;

    public ImplementationFactory(SgClassPool pool) {
        this(pool, false);
    }

    public ImplementationFactory(SgClassPool pool, boolean onlyDeclaredMethods) {
        this.assureNotNull("pool", pool);
        this.pool = pool;
        this.onlyDeclaredMethods = onlyDeclaredMethods;
    }

    public final SgClass create(String implPackageName, String implClassName, ImplementationFactoryListener listener, Class<?> ... intf) {
        return this.create(implPackageName, implClassName, null, null, listener, intf);
    }

    public final SgClass create(String implPackageName, String implClassName, SgClass superClass, SgClass enclosingClass, ImplementationFactoryListener listener, Class<?> ... intf) {
        this.assureNotNull("implPackageName", implPackageName);
        this.assureNotNull("implClassName", implClassName);
        this.assureNotNull("listener", listener);
        this.assureNotNull("intf", intf);
        this.assureNotEmpty("intf", intf);
        this.assureAllInterfaces(intf);
        SgClass clasz = new SgClass("public", implPackageName, implClassName, superClass, false, enclosingClass);
        for (int i = 0; i < intf.length; ++i) {
            clasz.addInterface(SgClass.create(this.pool, intf[i]));
        }
        listener.afterClassCreated(clasz);
        HashMap<String, ImplementedMethod> implMethods = new HashMap<String, ImplementedMethod>();
        for (int i = 0; i < intf.length; ++i) {
            this.addInterfaceMethods(implMethods, clasz, intf[i], listener);
        }
        Iterator it = implMethods.keySet().iterator();
        while (it.hasNext()) {
            ImplementedMethod implMethod = (ImplementedMethod)implMethods.get(it.next());
            SgMethod method = implMethod.getMethod();
            Class<?>[] interfaces = implMethod.getInterfaces();
            List<String> lines = listener.createBody(method, interfaces);
            for (int k = 0; k < lines.size(); ++k) {
                implMethod.getMethod().addBodyLine(lines.get(k));
            }
        }
        return clasz;
    }

    private void addInterfaceMethods(Map<String, ImplementedMethod> implMethods, SgClass clasz, Class<?> intf, ImplementationFactoryListener listener) {
        Method[] methods = this.onlyDeclaredMethods ? intf.getDeclaredMethods() : intf.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            int k;
            SgMethod method;
            String name = methods[j].getName();
            String typeSignature = SgUtils.createTypeSignature(name, methods[j].getParameterTypes());
            SgClass returnType = methods[j].getReturnType() == null ? SgClass.VOID : SgClass.create(this.pool, methods[j].getReturnType());
            ImplementedMethod implMethod = implMethods.get(typeSignature);
            if (implMethod == null) {
                method = new SgMethod(clasz, "public", returnType, name);
                Class<?>[] paramTypes = methods[j].getParameterTypes();
                for (k = 0; k < paramTypes.length; ++k) {
                    SgClass paramType = SgClass.create(this.pool, paramTypes[k]);
                    method.addArgument(new SgArgument(method, paramType, "arg" + k));
                }
                method.addAnnotations(SgUtils.createAnnotations(methods[j].getAnnotations()));
                implMethod = new ImplementedMethod(method);
                implMethod.addInterface(intf);
                implMethods.put(typeSignature, implMethod);
            } else {
                implMethod.addInterface(intf);
                if (!returnType.getName().equals(implMethod.getReturnType().getName())) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < implMethod.getInterfaces().length; ++i) {
                        if (i > 0) {
                            sb.append("' or '");
                        }
                        sb.append(implMethod.getInterfaces()[i].getName());
                    }
                    throw new IllegalArgumentException("Method '" + typeSignature + "' has different return types for interface '" + intf.getName() + "' and '" + sb + "'!");
                }
            }
            method = implMethod.getMethod();
            Class<?>[] exceptionTypes = methods[j].getExceptionTypes();
            for (k = 0; k < exceptionTypes.length; ++k) {
                SgClass ex = SgClass.create(this.pool, exceptionTypes[k]);
                if (method.getExceptions().indexOf(ex) != -1) continue;
                method.addException(ex);
            }
        }
    }

    private void assureNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be null!");
        }
    }

    private void assureNotEmpty(String name, Object[] value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be an empty array!");
        }
    }

    private void assureAllInterfaces(Class<?> ... intf) {
        for (int i = 0; i < intf.length; ++i) {
            if (intf[i].isInterface()) continue;
            throw new IllegalArgumentException("Expected an interface: " + intf[i].getName() + " [" + i + "]");
        }
    }
}

