/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgBehavior;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgMethod
extends SgBehavior {
    private final SgClass returnType;
    private final String name;
    private final List<String> body;

    public SgMethod(SgClass owner, String modifiers, SgClass returnType, String name) {
        super(owner, modifiers);
        if (returnType == null) {
            throw new IllegalArgumentException("The argument 'returnType' cannot be NULL!");
        }
        this.returnType = returnType;
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        this.name = name;
        this.body = new ArrayList<String>();
        owner.addMethod(this);
    }

    public final SgClass getReturnType() {
        return this.returnType;
    }

    public final List<String> getBody() {
        return Collections.unmodifiableList(this.body);
    }

    public final void addBodyLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("The argument 'line' cannot be NULL!");
        }
        this.body.add(line.trim());
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameAsPackage() {
        return SgUtils.uppercaseToUnderscore(this.getName());
    }

    public final String getSignature() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.getModifiers().length() > 0) {
            sb.append(this.getModifiers());
            sb.append(" ");
        }
        sb.append(this.returnType.getName());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        for (i = 0; i < this.getArguments().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getArguments().get(i));
        }
        sb.append(")");
        if (this.getExceptions().size() > 0) {
            sb.append(" throws ");
            for (i = 0; i < this.getExceptions().size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.getExceptions().get(i).getName());
            }
        }
        return sb.toString();
    }

    public final String getCallSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        for (int i = 0; i < this.getArguments().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SgArgument arg = this.getArguments().get(i);
            sb.append(arg.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public final String getTypeSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        for (int i = 0; i < this.getArguments().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            SgArgument arg = this.getArguments().get(i);
            sb.append(arg.getType().getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public final String getUnderscoredNameAndTypes() {
        StringBuffer sb = new StringBuffer();
        sb.append(SgUtils.firstCharUpper(this.getName()));
        sb.append("_");
        for (int i = 0; i < this.getArguments().size(); ++i) {
            if (i > 0) {
                sb.append("_");
            }
            SgArgument arg = this.getArguments().get(i);
            String typeName = arg.getType().getSimpleName();
            sb.append(SgUtils.replace(typeName, "[]", "ARRAY", -1));
        }
        return sb.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean showAnnotations) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (showAnnotations && this.getAnnotations().size() > 0) {
            for (i = 0; i < this.getAnnotations().size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.getAnnotations().get(i));
            }
            sb.append("\n");
        }
        sb.append(this.getSignature());
        if (this.getOwner().isInterface()) {
            sb.append(";");
        } else {
            sb.append("{\n");
            if (this.body.size() == 0) {
                sb.append("// No method source available\n");
            } else {
                for (i = 0; i < this.body.size(); ++i) {
                    sb.append(this.body.get(i));
                    sb.append("\n");
                }
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

