/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist.factory;

import java.lang.reflect.Method;
import java.util.List;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.factory.ImplementationFactoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationFactory {
    private final SgClassPool pool;

    public ImplementationFactory(SgClassPool pool) {
        this.assureNotNull("pool", pool);
        this.pool = pool;
    }

    public final SgClass create(String implPackageName, String implClassName, ImplementationFactoryListener listener, Class<?> ... intf) {
        return this.create(implPackageName, implClassName, null, null, listener, intf);
    }

    public final SgClass create(String implPackageName, String implClassName, SgClass superClass, SgClass enclosingClass, ImplementationFactoryListener listener, Class<?> ... intf) {
        int i;
        this.assureNotNull("implPackageName", implPackageName);
        this.assureNotNull("implClassName", implClassName);
        this.assureNotNull("listener", listener);
        this.assureNotNull("intf", intf);
        this.assureNotEmpty("intf", intf);
        this.assureAllInterfaces(intf);
        SgClass clasz = new SgClass("public", implPackageName, implClassName, superClass, false, enclosingClass);
        for (i = 0; i < intf.length; ++i) {
            clasz.addInterface(SgClass.create(this.pool, intf[i]));
        }
        listener.afterClassCreated(clasz);
        for (i = 0; i < intf.length; ++i) {
            this.addInterfaceMethods(clasz, intf[i], listener);
        }
        return clasz;
    }

    private void addInterfaceMethods(SgClass clasz, Class<?> intf, ImplementationFactoryListener listener) {
        Method[] methods = intf.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            String name = methods[j].getName();
            SgClass returnType = methods[j].getReturnType() == null ? SgClass.VOID : SgClass.create(this.pool, methods[j].getReturnType());
            SgMethod method = new SgMethod(clasz, "public", returnType, name);
            Class<?>[] paramTypes = methods[j].getParameterTypes();
            for (int k = 0; k < paramTypes.length; ++k) {
                SgClass paramType = SgClass.create(this.pool, paramTypes[k]);
                method.addArgument(new SgArgument(method, paramType, "arg" + k));
            }
            Class<?>[] exceptionTypes = methods[j].getExceptionTypes();
            for (int k = 0; k < exceptionTypes.length; ++k) {
                method.addException(SgClass.create(this.pool, exceptionTypes[k]));
            }
            List<String> lines = listener.createBody(method);
            for (int k = 0; k < lines.size(); ++k) {
                method.addBodyLine(lines.get(k));
            }
        }
    }

    private void assureNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be null!");
        }
    }

    private void assureNotEmpty(String name, Object[] value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("The argument '" + name + "' cannot be an empty array!");
        }
    }

    private void assureAllInterfaces(Class<?> ... intf) {
        for (int i = 0; i < intf.length; ++i) {
            if (intf[i].isInterface()) continue;
            throw new IllegalArgumentException("Expected an interface: " + intf[i].getName() + " [" + i + "]");
        }
    }
}

