/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.srcgen4javassist.factory;

import java.util.List;

import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgMethod;

/**
 * Creates the source code for the method implementations.
 */
public interface ImplementationFactoryListener {

	/**
	 * The class was just created and implements the interface. The listener may
	 * add constructors or fields here.
	 * 
	 * @param clasz
	 *            Class without any method yet.
	 */
	public void afterClassCreated(SgClass clasz);

	/**
	 * Creates the source code for a method.
	 * 
	 * @param method
	 *            Method to create source code for.
	 * 
	 * @return List of source lines.
	 */
	public List<String> createBody(final SgMethod method);

}
