/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SgVariable {
    private final String modifiers;
    private final SgClass type;
    private final String name;
    private final List<SgAnnotation> annotations;

    public SgVariable(String modifiers, SgClass type, String name) {
        if (modifiers == null) {
            throw new IllegalArgumentException("The argument 'modifiers' cannot be null!");
        }
        this.modifiers = modifiers;
        if (type == null) {
            throw new IllegalArgumentException("The argument 'type' cannot be null!");
        }
        this.type = type;
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        this.name = name;
        this.annotations = new ArrayList<SgAnnotation>();
    }

    public final String getModifiers() {
        return this.modifiers;
    }

    public final SgClass getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final List<SgAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public final void addAnnotation(SgAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("The argument 'annotation' cannot be NULL!");
        }
        this.annotations.add(annotation);
    }

    public final void addAnnotations(List<SgAnnotation> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("The argument 'annotations' cannot be NULL!");
        }
        this.annotations.addAll(annotations);
    }

    public final boolean hasAnnotation(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        int i = 0;
        while (i < this.annotations.size()) {
            SgAnnotation annotation = this.annotations.get(i);
            if (annotation.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

