/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgConstructor;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgClass {
    public static final SgClass VOID = new SgClass("", "", "void", false, null);
    public static final SgClass BOOLEAN = new SgClass("", "", "boolean", false, null);
    public static final SgClass BYTE = new SgClass("", "", "byte", false, null);
    public static final SgClass CHAR = new SgClass("", "", "char", false, null);
    public static final SgClass SHORT = new SgClass("", "", "short", false, null);
    public static final SgClass INT = new SgClass("", "", "int", false, null);
    public static final SgClass LONG = new SgClass("", "", "long", false, null);
    public static final SgClass FLOAT = new SgClass("", "", "float", false, null);
    public static final SgClass DOUBLE = new SgClass("", "", "double", false, null);
    public static final SgClass OBJECT = new SgClass("", "", "Object", false, null);
    private final String modifiers;
    private final String packageName;
    private final String simpleName;
    private final List<SgClass> interfaces;
    private final List<SgField> fields;
    private final boolean isinterface;
    private final SgClass superClass;
    private final List<SgConstructor> constructors;
    private final List<SgMethod> methods;
    private final List<SgClass> classes;
    private final SgClass enclosingClass;

    public SgClass(String packageName, String simpleName) {
        this("public", packageName, simpleName, null, false, null);
    }

    public SgClass(String modifiers, String packageName, String simpleName, boolean isinterface, SgClass enclosingClass) {
        this(modifiers, packageName, simpleName, null, isinterface, enclosingClass);
    }

    public SgClass(String modifiers, String packageName, String simpleName, SgClass superClass, boolean isinterface, SgClass enclosingClass) {
        this.modifiers = modifiers;
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.superClass = superClass;
        if (isinterface && superClass != null) {
            throw new IllegalArgumentException("This is an interface. You cannot set a super class. Use 'addInterface(SgClass)' instead!");
        }
        this.constructors = new ArrayList<SgConstructor>();
        this.methods = new ArrayList<SgMethod>();
        this.interfaces = new ArrayList<SgClass>();
        this.fields = new ArrayList<SgField>();
        this.isinterface = isinterface;
        this.classes = new ArrayList<SgClass>();
        this.enclosingClass = enclosingClass;
        if (enclosingClass != null) {
            this.enclosingClass.addClass(this);
        }
    }

    public final SgClass getSuperClass() {
        return this.superClass;
    }

    public final String getSimpleNameAsPackage() {
        return SgUtils.uppercaseToUnderscore(this.getSimpleName());
    }

    public final List<SgConstructor> getConstructors() {
        return Collections.unmodifiableList(this.constructors);
    }

    public final void addConstructor(SgConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("The argument 'constructor' cannot be null!");
        }
        if (constructor.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'constructor' is different from 'this'!");
        }
        if (!this.constructors.contains(constructor)) {
            this.constructors.add(constructor);
        }
    }

    public final boolean isInterface() {
        return this.isinterface;
    }

    public final List<SgMethod> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public final void addMethod(SgMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("The argument 'method' cannot be null!");
        }
        if (method.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'method' is different from 'this'!");
        }
        if (!this.methods.contains(method)) {
            this.methods.add(method);
        }
    }

    public final String getName() {
        return this.getName("$");
    }

    public final String getSourceName() {
        return this.getName(".");
    }

    public final String getNameAsFilename() {
        return this.getName().replace('.', File.separatorChar);
    }

    public final String getNameAsSrcFilename() {
        return String.valueOf(this.getNameAsFilename()) + ".java";
    }

    public final String getNameAsBinFilename() {
        return String.valueOf(this.getNameAsFilename()) + ".class";
    }

    private String getEnclosingSimpleNames(String innerDivider) {
        StringBuffer sb = new StringBuffer();
        SgClass clasz = this.enclosingClass;
        while (clasz != null) {
            sb.insert(0, innerDivider);
            sb.insert(0, clasz.getSimpleName());
            clasz = clasz.getEnclosingClass();
        }
        return sb.toString();
    }

    private final String getName(String innerDivider) {
        if (this.packageName.length() == 0) {
            if (this.enclosingClass == null) {
                return this.simpleName;
            }
            return String.valueOf(this.getEnclosingSimpleNames(innerDivider)) + this.simpleName;
        }
        if (this.enclosingClass == null) {
            return String.valueOf(this.packageName) + "." + this.simpleName;
        }
        return String.valueOf(this.packageName) + "." + this.getEnclosingSimpleNames(innerDivider) + this.simpleName;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final List<SgClass> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public final void addInterface(SgClass intf) {
        if (intf == null) {
            throw new IllegalArgumentException("The argument 'intf' cannot be null!");
        }
        this.interfaces.add(intf);
    }

    public final String getInterfacesCommaSeparated() {
        StringBuffer sb = new StringBuffer();
        if (this.interfaces.size() > 0) {
            int i = 0;
            while (i < this.interfaces.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.interfaces.get(i).getSourceName());
                ++i;
            }
        }
        return sb.toString();
    }

    public final List<SgField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public final void addField(SgField field) {
        if (field == null) {
            throw new IllegalArgumentException("The argument 'field' cannot be null!");
        }
        if (field.getOwner() != this) {
            throw new IllegalArgumentException("The owner of 'field' is different from 'this'!");
        }
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public final List<SgClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public final void addClass(SgClass clasz) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        if (!this.classes.contains(clasz)) {
            this.classes.add(clasz);
        }
    }

    public final SgClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public final SgClass findClassByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        int i = 0;
        while (i < this.classes.size()) {
            SgClass clasz = this.classes.get(i);
            if (clasz.getName().equals(name)) {
                return clasz;
            }
            ++i;
        }
        return null;
    }

    public final SgMethod findMethodByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        int i = 0;
        while (i < this.methods.size()) {
            SgMethod method = this.methods.get(i);
            if (method.getName().equals(name)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public final SgField findFieldByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        int i = 0;
        while (i < this.fields.size()) {
            SgField field = this.fields.get(i);
            if (field.getName().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    private void addPackageLine(StringBuffer sb) {
        if (this.enclosingClass == null && this.packageName.length() > 0) {
            sb.append("package ");
            sb.append(this.packageName);
            sb.append(";\n");
            sb.append("\n");
        }
    }

    private void addNameLine(StringBuffer sb) {
        if (this.modifiers.length() > 0) {
            sb.append(this.modifiers);
            sb.append(" ");
        }
        if (this.isinterface) {
            sb.append("interface ");
        } else {
            sb.append("class ");
        }
        sb.append(this.getSimpleName());
        if (this.isinterface) {
            if (this.interfaces.size() > 0) {
                sb.append(" extends ");
                sb.append(this.getInterfacesCommaSeparated());
            }
        } else {
            if (this.superClass != null && !"Object".equals(this.superClass.getName())) {
                sb.append(" extends ");
                sb.append(this.superClass.getSourceName());
            }
            if (this.interfaces.size() > 0) {
                sb.append(" implements ");
                sb.append(this.getInterfacesCommaSeparated());
            }
        }
        sb.append(" {\n");
    }

    private void addFields(StringBuffer sb) {
        int i = 0;
        while (i < this.getFields().size()) {
            sb.append(this.getFields().get(i) + "\n");
            sb.append("\n");
            ++i;
        }
        sb.append("\n");
    }

    private void addConstructors(StringBuffer sb) {
        int i = 0;
        while (i < this.constructors.size()) {
            sb.append(this.constructors.get(i) + "\n");
            sb.append("\n");
            ++i;
        }
        sb.append("\n");
    }

    private void addMethods(StringBuffer sb) {
        int i = 0;
        while (i < this.methods.size()) {
            sb.append(this.methods.get(i) + "\n");
            sb.append("\n");
            ++i;
        }
    }

    private void addInnerClasses(StringBuffer sb) {
        int i = 0;
        while (i < this.classes.size()) {
            sb.append(this.classes.get(i) + "\n");
            ++i;
        }
        sb.append("}\n");
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.addPackageLine(sb);
        this.addNameLine(sb);
        this.addFields(sb);
        this.addConstructors(sb);
        this.addMethods(sb);
        this.addInnerClasses(sb);
        return sb.toString();
    }

    private static List<SgAnnotation> createAnnotations(Annotation[] ann) {
        ArrayList<SgAnnotation> list = new ArrayList<SgAnnotation>();
        if (ann != null && ann.length > 0) {
            int i = 0;
            while (i < ann.length) {
                SgAnnotation annotation = new SgAnnotation(ann[i].annotationType().getPackage().getName(), ann[i].annotationType().getSimpleName());
                list.add(annotation);
                ++i;
            }
        }
        return list;
    }

    public static SgClass create(SgClassPool pool, String className) {
        if (pool == null) {
            throw new IllegalArgumentException("The argument 'pool' cannot be null!");
        }
        if (className == null) {
            throw new IllegalArgumentException("The argument 'className' cannot be null!");
        }
        SgClass cached = pool.get(className);
        if (cached != null) {
            return cached;
        }
        try {
            return SgClass.create(pool, Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot create '" + className + "'!", e);
        }
    }

    public static SgClass create(SgClassPool pool, Class clasz) {
        if (pool == null) {
            throw new IllegalArgumentException("The argument 'pool' cannot be null!");
        }
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        SgClass cached = pool.get(clasz.getName());
        if (cached != null) {
            return cached;
        }
        try {
            SgClass cl = SgClass.createClass(pool, clasz);
            SgClass.addInterfaces(pool, cl, clasz);
            SgClass.addFields(pool, cl, clasz);
            SgClass.addConstructors(pool, cl, clasz);
            SgClass.addMethods(pool, cl, clasz);
            SgClass.addInnerClasses(pool, cl, clasz);
            return cl;
        }
        catch (RuntimeException ex) {
            System.out.println("ERROR CLASS: " + clasz);
            throw ex;
        }
    }

    private static SgClass createClass(SgClassPool pool, Class clasz) {
        SgClass enclosingClass = clasz.getEnclosingClass() == null ? null : SgClass.create(pool, clasz.getEnclosingClass());
        String clModifiers = Modifier.toString(clasz.getModifiers());
        String packageName = clasz.getPackage() == null ? "" : clasz.getPackage().getName();
        SgClass superClass = clasz.isInterface() ? null : SgClass.create(pool, clasz.getSuperclass());
        SgClass cl = new SgClass(clModifiers, packageName, clasz.getSimpleName(), superClass, clasz.isInterface(), enclosingClass);
        if (clasz.isArray()) {
            pool.put(clasz.getName(), cl);
        } else {
            pool.put(cl);
        }
        return cl;
    }

    private static void addInterfaces(SgClassPool pool, SgClass cl, Class clasz) {
        Class<?>[] interfaces = clasz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            cl.addInterface(SgClass.create(pool, interfaces[i]));
            ++i;
        }
    }

    private static void addFields(SgClassPool pool, SgClass cl, Class clasz) {
        Field[] fields = clasz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            SgClass type = SgClass.create(pool, fields[i].getType());
            String name = fields[i].getName();
            String modifiers = Modifier.toString(fields[i].getModifiers());
            SgField field = new SgField(cl, modifiers, type, name, null);
            field.addAnnotations(SgClass.createAnnotations(fields[i].getAnnotations()));
            ++i;
        }
    }

    private static void addConstructors(SgClassPool pool, SgClass cl, Class clasz) {
        if (!cl.isInterface()) {
            Constructor<?>[] constructors = clasz.getDeclaredConstructors();
            int i = 0;
            while (i < constructors.length) {
                SgConstructor constructor = new SgConstructor(cl, Modifier.toString(constructors[i].getModifiers()));
                Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                int j = 0;
                while (j < parameterTypes.length) {
                    new SgArgument(constructor, SgClass.create(pool, parameterTypes[j]), "p" + j);
                    ++j;
                }
                Class<?>[] exceptions = constructors[i].getExceptionTypes();
                int j2 = 0;
                while (j2 < exceptions.length) {
                    constructor.addException(SgClass.create(pool, clasz));
                    ++j2;
                }
                cl.addConstructor(constructor);
                ++i;
            }
        }
    }

    private static void addMethods(SgClassPool pool, SgClass cl, Class clasz) {
        Method[] methods = clasz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            String mModifiers = Modifier.toString(methods[i].getModifiers());
            SgClass returnType = SgClass.create(pool, methods[i].getReturnType());
            SgMethod method = new SgMethod(cl, mModifiers, returnType, methods[i].getName());
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            int j = 0;
            while (j < parameterTypes.length) {
                new SgArgument(method, SgClass.create(pool, parameterTypes[j]), "p" + j);
                ++j;
            }
            method.addAnnotations(SgClass.createAnnotations(methods[i].getAnnotations()));
            Class<?>[] exceptions = methods[i].getExceptionTypes();
            int j2 = 0;
            while (j2 < exceptions.length) {
                method.addException(SgClass.create(pool, clasz));
                ++j2;
            }
            cl.addMethod(method);
            ++i;
        }
    }

    private static void addInnerClasses(SgClassPool pool, SgClass cl, Class clasz) {
        Class<?>[] innerClasses = clasz.getClasses();
        int i = 0;
        while (i < innerClasses.length) {
            cl.addClass(SgClass.create(pool, innerClasses[i]));
            ++i;
        }
    }

    public final String getModifiers() {
        return this.modifiers;
    }
}

