/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgConstructor;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SgUtils;

public final class ByteCodeGenerator {
    private final ClassPool pool;
    private final ClassLoader classLoader;
    private final ProtectionDomain domain;

    public ByteCodeGenerator() {
        this(null, null, null);
    }

    public ByteCodeGenerator(ClassPool pool) {
        this(pool, null, null);
    }

    public ByteCodeGenerator(ClassPool pool, ClassLoader classLoader) {
        this(pool, classLoader, null);
    }

    public ByteCodeGenerator(ClassPool pool, ClassLoader classLoader, ProtectionDomain domain) {
        this.pool = pool == null ? ClassPool.getDefault() : pool;
        this.classLoader = this.pool.getClassLoader();
        this.domain = null;
    }

    private CtClass createCtClass(SgClass modelClass) throws NotFoundException, CannotCompileException {
        CtClass clasz = this.pool.makeClass(modelClass.getName());
        clasz.setModifiers(SgUtils.toModifiers(modelClass.getModifiers()));
        if (modelClass.getSuperClass() != null) {
            clasz.setSuperclass(this.pool.get(modelClass.getSuperClass().getName()));
        }
        this.addInterfaces(modelClass, clasz);
        this.addFields(modelClass, clasz);
        this.addConstructors(modelClass, clasz);
        this.addMethods(modelClass, clasz);
        return clasz;
    }

    private void addMethods(SgClass modelClass, CtClass clasz) throws CannotCompileException, NotFoundException {
        List<SgMethod> methods = modelClass.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            SgMethod method = methods.get(i);
            String src = method.toString();
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clasz);
            clasz.addMethod(ctMethod);
            List<SgClass> exceptions = method.getExceptions();
            if (exceptions.size() <= 0) continue;
            CtClass[] exceptionTypes = new CtClass[exceptions.size()];
            for (int j = 0; j < exceptions.size(); ++j) {
                exceptionTypes[j] = this.createCtClass(exceptions.get(j));
            }
            ctMethod.setExceptionTypes(exceptionTypes);
        }
    }

    private void addConstructors(SgClass modelClass, CtClass clasz) throws CannotCompileException, NotFoundException {
        List<SgConstructor> constructors = modelClass.getConstructors();
        for (int i = 0; i < constructors.size(); ++i) {
            SgConstructor constructor = constructors.get(i);
            String src = constructor.toString();
            CtConstructor ctConstructor = CtNewConstructor.make((String)src, (CtClass)clasz);
            clasz.addConstructor(ctConstructor);
            List<SgClass> exceptions = constructor.getExceptions();
            if (exceptions.size() <= 0) continue;
            CtClass[] exceptionTypes = new CtClass[exceptions.size()];
            for (int j = 0; j < exceptions.size(); ++j) {
                exceptionTypes[j] = this.createCtClass(exceptions.get(j));
            }
            ctConstructor.setExceptionTypes(exceptionTypes);
        }
    }

    private void addFields(SgClass modelClass, CtClass clasz) throws CannotCompileException {
        List<SgField> fields = modelClass.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            SgField field = fields.get(i);
            String src = field.toString();
            CtField ctField = CtField.make((String)src, (CtClass)clasz);
            clasz.addField(ctField);
        }
    }

    private void addInterfaces(SgClass modelClass, CtClass clasz) throws NotFoundException {
        List<SgClass> interfaces = modelClass.getInterfaces();
        if (interfaces.size() > 0) {
            for (int i = 0; i < interfaces.size(); ++i) {
                SgClass intf = interfaces.get(i);
                clasz.addInterface(this.pool.get(intf.getName()));
            }
        }
    }

    public final Class createClass(SgClass modelClass) {
        Class implClass = this.loadClass(modelClass);
        if (implClass == null) {
            try {
                CtClass clasz = this.createCtClass(modelClass);
                implClass = clasz.toClass(this.classLoader, this.domain);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException(e);
            }
        }
        return implClass;
    }

    public Class loadClass(SgClass modelClass) {
        Class<?> implClass;
        try {
            implClass = Class.forName(modelClass.getName());
        }
        catch (ClassNotFoundException e) {
            implClass = null;
        }
        return implClass;
    }

    public final Object createInstance(Class clasz) {
        return this.createInstance(clasz, new Class[0], new Object[0]);
    }

    public final Object createInstance(Class clasz, Class[] argTypes, Object[] initArgs) {
        try {
            Constructor constructor = clasz.getConstructor(argTypes);
            return constructor.newInstance(initArgs);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Object createInstance(SgClass clasz, Class[] argTypes, Object[] initArgs) {
        Class newClass = this.createClass(clasz);
        return this.createInstance(newClass, argTypes, initArgs);
    }

    public final Object createInstance(SgClass clasz) {
        Class newClass = this.createClass(clasz);
        return this.createInstance(newClass, new Class[0], new Object[0]);
    }

    public static ByteCodeGenerator createWithCurrentThreadContextClassLoader() {
        ClassPool pool = ClassPool.getDefault();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        return new ByteCodeGenerator(pool, classLoader);
    }
}

