/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgVariable;

public final class SgField
extends SgVariable {
    private final SgClass owner;
    private String initializer = null;

    public SgField(SgClass owner, String modifiers, SgClass type, String name) {
        super(modifiers, type, name);
        if (owner == null) {
            throw new IllegalArgumentException("The argument 'owner' cannot be null!");
        }
        this.owner = owner;
        owner.addField(this);
    }

    public final SgClass getOwner() {
        return this.owner;
    }

    public final String getInitializer() {
        return this.initializer;
    }

    public final void setInitializer(String initializer) {
        this.initializer = initializer;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getAnnotations().size() > 0) {
            for (int i = 0; i < this.getAnnotations().size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.getAnnotations().get(i));
            }
            sb.append("\n");
        }
        if (this.getModifiers().length() == 0) {
            sb.append(this.getType().getSourceName() + " " + this.getName());
        } else {
            sb.append(this.getModifiers() + " " + this.getType().getSourceName() + " " + this.getName());
        }
        if (this.initializer == null) {
            sb.append(" /** No initializer source available */ ");
        } else if (this.initializer.length() > 0) {
            sb.append(" = ");
            sb.append(this.initializer);
        }
        sb.append(";\n");
        return sb.toString();
    }
}

