/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.List;
import javassist.Modifier;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.srcgen4javassist.SourceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgUtils {
    private SgUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of this class!");
    }

    private static void writeVisibility(SourceWriter src, int modifiers) {
        if (Modifier.isPrivate((int)modifiers)) {
            src.write(" ", "private");
        }
        if (Modifier.isProtected((int)modifiers)) {
            src.write(" ", "protected");
        }
        if (Modifier.isPublic((int)modifiers)) {
            src.write(" ", "public");
        }
    }

    public static String createClassModifiers(int modifiers, boolean isInterface, boolean isInnerClass) {
        SourceWriter src = new SourceWriter();
        SgUtils.writeVisibility(src, modifiers);
        if (!(isInterface && isInnerClass || !Modifier.isStatic((int)modifiers))) {
            src.write(" ", "static");
        }
        if (!isInterface && Modifier.isAbstract((int)modifiers)) {
            src.write(" ", "abstract");
        }
        if (Modifier.isFinal((int)modifiers)) {
            src.write(" ", "final");
        }
        return src.toString();
    }

    public static String createFieldModifiers(int modifiers) {
        SourceWriter src = new SourceWriter();
        SgUtils.writeVisibility(src, modifiers);
        if (Modifier.isStatic((int)modifiers)) {
            src.write(" ", "static");
        }
        if (Modifier.isFinal((int)modifiers)) {
            src.write(" ", "final");
        }
        if (Modifier.isTransient((int)modifiers)) {
            src.write(" ", "transient");
        }
        if (Modifier.isVolatile((int)modifiers)) {
            src.write(" ", "volatile");
        }
        return src.toString();
    }

    public static String createMethodModifiers(int modifiers, boolean isInterface) {
        SourceWriter src = new SourceWriter();
        SgUtils.writeVisibility(src, modifiers);
        if (Modifier.isStatic((int)modifiers)) {
            src.write(" ", "static");
        }
        if (!isInterface && Modifier.isAbstract((int)modifiers)) {
            src.write(" ", "abstract");
        }
        if (Modifier.isFinal((int)modifiers)) {
            src.write(" ", "final");
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            src.write(" ", "synchronized");
        }
        return src.toString();
    }

    public static String createConstructorModifiers(int modifiers) {
        SourceWriter src = new SourceWriter();
        SgUtils.writeVisibility(src, modifiers);
        return src.toString();
    }

    public static String uppercaseToUnderscore(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(Character.toLowerCase(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String firstCharUpper(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return "" + Character.toUpperCase(str.charAt(0));
        }
        return String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    public static String concatPackages(String package1, String package2) {
        if (package1 == null || package1.length() == 0) {
            if (package2 == null || package2.length() == 0) {
                return "";
            }
            return package2;
        }
        return String.valueOf(package1) + "." + package2;
    }

    public static void addToStringMethod(SgClassPool pool, SgClass clasz, List<SgField> fields) {
        SgMethod m = new SgMethod(clasz, "public", SgClass.create(pool, String.class), "toString");
        m.addBodyLine("return getClass().getSimpleName() + \"{\"");
        int i = 0;
        while (i < fields.size()) {
            SgField field = fields.get(i);
            String nameValue = " + \"" + field.getName() + "=\" + " + field.getName();
            if (i < fields.size() - 1) {
                m.addBodyLine(String.valueOf(nameValue) + " + \", \"");
            } else {
                m.addBodyLine(nameValue);
            }
            ++i;
        }
        m.addBodyLine(" + \"}\";");
        clasz.addMethod(m);
    }
}

