/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgBehavior;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgMethod
extends SgBehavior {
    private final SgClass returnType;
    private final String name;
    private final List<String> body;
    private final List<SgAnnotation> annotations;

    public SgMethod(SgClass clasz, String modifiers, SgClass returnType, String name) {
        super(clasz, modifiers);
        if (returnType == null) {
            throw new IllegalArgumentException("The argument 'returnType' cannot be NULL!");
        }
        this.returnType = returnType;
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        this.name = name;
        this.body = new ArrayList<String>();
        this.annotations = new ArrayList<SgAnnotation>();
    }

    public final SgClass getReturnType() {
        return this.returnType;
    }

    public final List<String> getBody() {
        return this.body;
    }

    public final void addBodyLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("The argument 'line' cannot be NULL!");
        }
        this.body.add(line.trim());
    }

    public final List<SgAnnotation> getAnnotations() {
        return this.annotations;
    }

    public final void addAnnotation(SgAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("The argument 'annotation' cannot be NULL!");
        }
        this.annotations.add(annotation);
    }

    public final void addAnnotations(List<SgAnnotation> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("The argument 'annotations' cannot be NULL!");
        }
        this.annotations.addAll(annotations);
    }

    public final boolean hasAnnotation(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        int i = 0;
        while (i < this.annotations.size()) {
            SgAnnotation annotation = this.annotations.get(i);
            if (annotation.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameAsPackage() {
        return SgUtils.uppercaseToUnderscore(this.getName());
    }

    public final String getSignature() {
        StringBuffer sb = new StringBuffer();
        if (this.getModifiers().length() > 0) {
            sb.append(this.getModifiers());
            sb.append(" ");
        }
        sb.append(this.returnType.getName());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        int i = 0;
        while (i < this.getArguments().size()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getArguments().get(i));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public final String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.annotations.size() > 0) {
            i = 0;
            while (i < this.annotations.size()) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.annotations.get(i));
                ++i;
            }
            sb.append("\n");
        }
        sb.append(this.getSignature());
        if (this.getJmsMvcClass().isInterface()) {
            sb.append(";");
        } else {
            sb.append("{\n");
            if (this.body.size() == 0) {
                sb.append("// No method source available\n");
            } else {
                i = 0;
                while (i < this.body.size()) {
                    sb.append(this.body.get(i));
                    sb.append("\n");
                    ++i;
                }
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

