/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.List;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SgBehavior {
    private final SgClass clasz;
    private final String modifiers;
    private final List<SgArgument> arguments;
    private final List<SgClass> exceptions;

    public SgBehavior(SgClass clasz, String modifiers) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        this.clasz = clasz;
        if (modifiers == null) {
            throw new IllegalArgumentException("The argument 'modifiers' cannot be null!");
        }
        this.modifiers = modifiers;
        this.arguments = new ArrayList<SgArgument>();
        this.exceptions = new ArrayList<SgClass>();
    }

    public SgBehavior(SgClass clasz, String modifiers, List<SgArgument> arguments) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        this.clasz = clasz;
        if (modifiers == null) {
            throw new IllegalArgumentException("The argument 'modifiers' cannot be null!");
        }
        this.modifiers = modifiers;
        this.arguments = new ArrayList<SgArgument>();
        this.arguments.addAll(arguments);
        this.exceptions = new ArrayList<SgClass>();
    }

    public final SgClass getJmsMvcClass() {
        return this.clasz;
    }

    public final String getModifiers() {
        return this.modifiers;
    }

    public final List<SgArgument> getArguments() {
        return this.arguments;
    }

    private static final String commaSeparated(List<SgArgument> args) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(args.get(i).getName());
            ++i;
        }
        return sb.toString();
    }

    public final String getCommaSeparatedArgumentNames(int less) {
        List<SgArgument> args = this.getArguments(less);
        return SgBehavior.commaSeparated(args);
    }

    public final String getCommaSeparatedArgumentNames() {
        return SgBehavior.commaSeparated(this.arguments);
    }

    public final List<SgArgument> getArguments(int less) {
        if (less >= 0) {
            throw new IllegalArgumentException("Only negative values are allowed! [" + less + "]");
        }
        int count = this.arguments.size() + less;
        if (count < 0) {
            throw new IllegalArgumentException("There are only " + this.arguments.size() + " arguments! Subtracting '" + less + "' would be below zero!");
        }
        ArrayList<SgArgument> list = new ArrayList<SgArgument>();
        int i = 0;
        while (i < count) {
            list.add(this.arguments.get(i));
            ++i;
        }
        return list;
    }

    public final SgArgument getLastArgument() {
        int size = this.arguments.size();
        if (size == 0) {
            return null;
        }
        return this.arguments.get(size - 1);
    }

    public final void addArgument(SgArgument arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The argument 'arg' cannot be null!");
        }
        this.arguments.add(arg);
    }

    public final List<SgClass> getExceptions() {
        return this.exceptions;
    }

    public final void addException(SgClass clasz) {
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        this.exceptions.add(clasz);
    }
}

