/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgConstructor;
import org.fuin.srcgen4javassist.SgField;
import org.fuin.srcgen4javassist.SgMethod;

public final class ByteCodeGenerator {
    private final ClassPool pool;
    private final ClassLoader classLoader;
    private final ProtectionDomain domain;

    public ByteCodeGenerator() {
        this(null, null, null);
    }

    public ByteCodeGenerator(ClassPool pool, ClassLoader classLoader) {
        this(pool, classLoader, null);
    }

    public ByteCodeGenerator(ClassPool pool, ClassLoader classLoader, ProtectionDomain domain) {
        this.pool = pool == null ? ClassPool.getDefault() : pool;
        this.classLoader = this.pool.getClassLoader();
        this.domain = null;
    }

    private CtClass createCtClass(SgClass modelClass) throws NotFoundException, CannotCompileException {
        List<SgClass> interfaces;
        CtClass clasz = this.pool.makeClass(modelClass.getName());
        if (modelClass.getSuperClass() != null) {
            clasz.setSuperclass(this.pool.get(modelClass.getSuperClass().getName()));
        }
        if ((interfaces = modelClass.getInterfaces()).size() > 0) {
            int i = 0;
            while (i < interfaces.size()) {
                SgClass intf = interfaces.get(i);
                clasz.addInterface(this.pool.get(intf.getName()));
                ++i;
            }
        }
        List<SgField> fields = modelClass.getFields();
        int i = 0;
        while (i < fields.size()) {
            SgField field = fields.get(i);
            String src = field.toString();
            CtField ctField = CtField.make((String)src, (CtClass)clasz);
            clasz.addField(ctField);
            ++i;
        }
        List<SgConstructor> constructors = modelClass.getConstructors();
        int i2 = 0;
        while (i2 < constructors.size()) {
            SgConstructor constructor = constructors.get(i2);
            String src = constructor.toString();
            CtConstructor ctConstructor = CtNewConstructor.make((String)src, (CtClass)clasz);
            clasz.addConstructor(ctConstructor);
            ++i2;
        }
        List<SgMethod> methods = modelClass.getMethods();
        int i3 = 0;
        while (i3 < methods.size()) {
            SgMethod method = methods.get(i3);
            String src = method.toString();
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clasz);
            clasz.addMethod(ctMethod);
            ++i3;
        }
        return clasz;
    }

    public final Class createClass(SgClass modelClass) {
        Class implClass = this.loadClass(modelClass);
        if (implClass == null) {
            try {
                CtClass clasz = this.createCtClass(modelClass);
                implClass = clasz.toClass(this.classLoader, this.domain);
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException(e);
            }
        }
        return implClass;
    }

    private Class loadClass(SgClass modelClass) {
        Class<?> implClass;
        try {
            implClass = Class.forName(modelClass.getName());
        }
        catch (ClassNotFoundException e) {
            implClass = null;
        }
        return implClass;
    }

    public final Object createInstance(Class clasz) {
        return this.createInstance(clasz, new Class[0], new Object[0]);
    }

    public final Object createInstance(Class clasz, Class[] argTypes, Object[] initArgs) {
        try {
            Constructor constructor = clasz.getConstructor(argTypes);
            return constructor.newInstance(initArgs);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final Object createInstance(SgClass clasz, Class[] argTypes, Object[] initArgs) {
        Class newClass = this.createClass(clasz);
        return this.createInstance(newClass, argTypes, initArgs);
    }

    public final Object createInstance(SgClass clasz) {
        Class newClass = this.createClass(clasz);
        return this.createInstance(newClass, new Class[0], new Object[0]);
    }

    public static ByteCodeGenerator createWithCurrentThreadContextClassLoader() {
        ClassPool pool = ClassPool.getDefault();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        return new ByteCodeGenerator(pool, classLoader);
    }
}

