/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.srcgen4javassist;

import java.util.ArrayList;
import java.util.List;
import org.fuin.srcgen4javassist.SgAnnotation;
import org.fuin.srcgen4javassist.SgClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgField {
    private final String modifiers;
    private final SgClass clasz;
    private final String name;
    private String initializer = null;
    private final List<SgAnnotation> annotations;

    public SgField(String modifiers, SgClass clasz, String name) {
        if (modifiers == null) {
            throw new IllegalArgumentException("The argument 'modifiers' cannot be null!");
        }
        this.modifiers = modifiers;
        if (clasz == null) {
            throw new IllegalArgumentException("The argument 'clasz' cannot be null!");
        }
        this.clasz = clasz;
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be null!");
        }
        this.name = name;
        this.annotations = new ArrayList<SgAnnotation>();
    }

    public final String getModifiers() {
        return this.modifiers;
    }

    public final SgClass getClasz() {
        return this.clasz;
    }

    public final String getName() {
        return this.name;
    }

    public final String getInitializer() {
        return this.initializer;
    }

    public final void setInitializer(String initializer) {
        this.initializer = initializer;
    }

    public final List<SgAnnotation> getAnnotations() {
        return this.annotations;
    }

    public final void addAnnotation(SgAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("The argument 'annotation' cannot be NULL!");
        }
        this.annotations.add(annotation);
    }

    public final void addAnnotations(List<SgAnnotation> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("The argument 'annotations' cannot be NULL!");
        }
        this.annotations.addAll(annotations);
    }

    public final boolean hasAnnotation(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' cannot be NULL!");
        }
        int i = 0;
        while (i < this.annotations.size()) {
            SgAnnotation annotation = this.annotations.get(i);
            if (annotation.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.annotations.size() > 0) {
            int i = 0;
            while (i < this.annotations.size()) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.annotations.get(i));
                ++i;
            }
            sb.append("\n");
        }
        if (this.modifiers.length() == 0) {
            sb.append(String.valueOf(this.clasz.getSourceName()) + " " + this.name);
        } else {
            sb.append(String.valueOf(this.modifiers) + " " + this.clasz.getSourceName() + " " + this.name);
        }
        if (this.initializer == null) {
            sb.append(" /** No initializer source available */ ");
        } else if (this.initializer.length() > 0) {
            sb.append(" = ");
            sb.append(this.initializer);
        }
        sb.append(";\n");
        return sb.toString();
    }
}

