/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.serialver4j.hessian;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import org.fuin.serialver4j.base.ClassesHistory;
import org.fuin.serialver4j.base.Converter;
import org.fuin.serialver4j.base.VersionedClass;
import org.fuin.serialver4j.base.VersioningSerializer;

public abstract class AbstractVersioningHessianSerializer
implements VersioningSerializer {
    private final ClassesHistory history;
    private final int pushbackBufSize;
    private final SerializerFactory serializerFactory;

    public AbstractVersioningHessianSerializer(ClassesHistory history, int pushbackBufSize, SerializerFactory serializerFactory) {
        this.history = history;
        this.pushbackBufSize = pushbackBufSize;
        this.serializerFactory = serializerFactory;
    }

    protected final void serialize(AbstractHessianOutput output, Object obj) throws IOException {
        output.setSerializerFactory(this.serializerFactory);
        output.writeObject(obj);
    }

    protected final Object readObject(AbstractHessianInput input, long version, String type) throws IOException {
        Converter<? extends Object, ? extends Object> converter;
        input.setSerializerFactory(this.serializerFactory);
        VersionedClass versionedClass = this.history.findVersionedClass(type);
        if (versionedClass == null) {
            return input.readObject();
        }
        Class<?> archivedClass = versionedClass.findArchivedClass(version);
        if (archivedClass == null) {
            return input.readObject();
        }
        Object obj = input.readObject(archivedClass);
        if (!archivedClass.isInstance(obj)) {
            throw new IllegalStateException("Expected class '" + archivedClass.getName() + "', but was:" + obj.getClass().getName());
        }
        while ((converter = this.history.findConverter(obj.getClass())) != null) {
            obj = converter.convert(obj);
        }
        return obj;
    }

    public final int getPushbackBufSize() {
        return this.pushbackBufSize;
    }

    public final String getVersionTag() {
        return this.history.getVersionTag();
    }
}

